package com.cftech.like.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * wx_comment 实体类
 * 点赞表
 * Created by mubo 10/05/2017.
 */
@Data
public class Like implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 服务号或企业号标识
     */

    private Long accountsId;
    /**
     * 被点赞模块枚举
     */
    private String moduleType;
    /**
     * 点赞实体主键
     */
    private Long entityId;

    /**
     * 操作类型枚举（点赞/取消点赞/踩/取消踩）
     */
    private String type;

    /**
     * 点赞人
     */
    private String userId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 记录时效性
     */
    private Boolean delFlag;


    public Like() {
        this.delFlag = false;
    }
}