package com.cftech.reportform.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.reportform.model.ReportForm;
import com.cftech.reportform.dao.ReportFormMapper;
import com.cftech.reportform.model.ReportFormDetail;
import com.cftech.reportform.service.ReportFormService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 报表管理ServiceImpl
 *
 * @author Licc
 * @date: 2020-10-16 14:33
 */
@Service("reportFormService")
public class ReportFormServiceImpl extends GenericServiceImpl<ReportForm> implements ReportFormService {

    @Autowired
    @Qualifier("reportFormMapper")
    private ReportFormMapper reportFormMapper;

    @Override
    public GenericDao<ReportForm> getGenericMapper() {
        return reportFormMapper;
    }

    @Override
    public List<ReportFormDetail> selectReportDetail(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return reportFormMapper.selectReportDetail(params);
    }
}