package com.cftech.accounts.model;

import com.cftech.sys.model.BasicEntity;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.codehaus.jackson.map.annotate.JsonSerialize;
/**
 * 服务号账户 
 * @author Jasper Huang
 *
 */
@JsonSerialize
@JsonNaming(PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
public class MpAccountsEntity extends BasicEntity {
	private static final long serialVersionUID = 6796396505275489918L;
	
	private String appid;
	private String secret;
	private String encodingaeskey;
	private String token;
	private Long userid;//创建人ID
	private String accesstoken;
	private String wctype; // 服务号和企业号, 0是服务号，1是企业号
	private String jsapi_ticket;//微信jssdk

	private String uploadType;

	private String agentId;

	public String getUploadType() {
		return uploadType;
	}

	public void setUploadType(String uploadType) {
		this.uploadType = uploadType;
	}

	public String getWctype() {
		return wctype;
	}

	public void setWctype(String wctype) {
		this.wctype = wctype;
	}

	public String getJsapi_ticket() {
		return jsapi_ticket;
	}
	public void setJsapi_ticket(String jsapi_ticket) {
		this.jsapi_ticket = jsapi_ticket;
	}
	
	public String getAppid() {
		return appid;
	}
	public void setAppid(String appid) {
		this.appid = appid;
	}
	public String getSecret() {
		return secret;
	}
	public void setSecret(String secret) {
		this.secret = secret;
	}
	public String getEncodingaeskey() {
		return encodingaeskey;
	}
	public void setEncodingaeskey(String encodingaeskey) {
		this.encodingaeskey = encodingaeskey;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public Long getUserid() {
		return userid;
	}
	public void setUserid(Long userid) {
		this.userid = userid;
	}
	public String getAccesstoken() {
		return accesstoken;
	}
	public void setAccesstoken(String accesstoken) {
		this.accesstoken = accesstoken;
	}

	public String getAgentId() {
		return agentId;
	}

	public void setAgentId(String agentId) {
		this.agentId = agentId;
	}
}
