var register = (function () {
  'use strict';
  var Register = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/feedback/save',
      getApi: G.baseUri() + '/mobile/auth/feedback/getDetail',
      vt: ''
    };
    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;
    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    if (p.params.devMode) {
      p.params.dataApi = 'json/code.json';
      p.params.returnqustion = 'json/code.json';
    }

    p.typeIds = [0,2,3,4,5,6];

    p.typeNames = [
        "产品购买Product inquiry",
        //"质量投诉Quality complaint",
        "防伪查询Origin Check",
        "商务合作Cooperation inquiry",
        "求职问询Job Search",
        "媒体联系News & Media",
        "其他Others"
    ];
    p.typeEmails = [
        "info_China@schaeffler.com",
       // "parkclh@schaeffler.com",
        "Piracy@schaeffler.com;Piracy_CN@schaeffler.com",
        "info_China@schaeffler.com",
        "CN_Recruitment@schaeffler.com",
        "liyum@schaeffler.com",
        "info_china@schaeffler.com"]
      // p.typeEmails = [
      //     "starsoy@163.com,lishiwei@michang-tech.com.cn",
      //     "starsoy@163.com",
      //     "starsoy@163.com",
      //     "starsoy@163.com",
      //     "starsoy@163.com",
      //     "starsoy@163.com",
      //     "zhangya2@schaeffler.com"]

    var serverId;

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        if(cfApp.getQueryString('test')=='test'){
            p.typeEmails = [
                "starsoy@163.com,lishiwei@michang-tech.com.cn",
                "starsoy@163.com",
                "starsoy@163.com",
                "starsoy@163.com",
                "starsoy@163.com",
                "starsoy@163.com",
                "zhangya2@schaeffler.com"]
        }
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {


      if (initBaseFields()) {
          agreement();
        log();
        submit();
        loadData();
        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "相关问询",
        modulename: "相关问询",
        keyword: "相关问询",
        keywordid: cfApp.getQueryString('id'),
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

      var agreement=function(){
          $('#showAgreement').click(function(){
              $('html,body').animate({scrollTop:0},0);
              $('#agreement-content').show();
              $('#maincontent').hide();
          });
          $('#return').click(function(){
              var h = $(document).height()-$(window).height();
              $(document).scrollTop(h);
              $('#agreement-content').hide();
              $('#maincontent').show();
          });

          $('#agreement').click(function(){
              $(this).toggleClass('choose');
          })
      }

      $("#type").picker({
          title: "请选择您想咨询的类别",
          cols: [
              {
                  textAlign: 'center',
                  values: p.typeNames
              }
          ],
          onClose:function(){
          }
      });

      //查询是否之前咨询过
      var loadData = function(){
          var formdata = {
              openid:p.empInfo.openId
          }
          G.ajax("get", p.params.getApi, formdata, function (retdata) {
              if(retdata.errorNo=='0' && retdata.data){
                  $("#name").val(retdata.data.name);
                  $("#phone").val(retdata.data.phone);
                  $("#email").val(retdata.data.email);
                  $("#company").val(retdata.data.company);
                  $("#address").val(retdata.data.address);
              }
          })
      }


    //提交相关问询
    var submit = function () {
      $('#submit').click(function () {

        var email = $('#email').val();
        if (StringValidateUtils.isEmpty(email)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入您的邮箱</span><br>Please input the e-mail',
            buttons: [{
              text: "确定OK"
            }]
          });


          return false;

        }
        var type = $('#type').val();
        if (StringValidateUtils.isEmpty(type)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请选择您咨询的类型！</span><br>Please choose inquiry category',
            buttons: [{
              text: "确定OK"
            }]
          });
          return false;
        }

        var content = $('#content').val();
        if (StringValidateUtils.isEmpty(content)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入您想咨询的问题！</span><br>Please input the message',
            buttons: [{
              text: "确定OK"
            }]
          });
          return false;
        }
          if(!$('#agreement').hasClass('choose')){
              $.modal({
                  title: "",
                  text: '<span class="color-green">请同意用户协议！</span><br>Please agree to the user agreement',
                  buttons: [{
                      text: "确定OK"
                  }]
              });
              return false;
          }

        var name = $("#name").val();
        var company = $("#company").val();
        var phone = $("#phone").val();
        var address = $("#address").val();
        var content = $("#content").val();
        var typeName = $("#type").val();


        var typeId = p.typeNames.indexOf($("#type").val());

        var formdata = {
          accountsId: p.params.accountsId,
          field1: p.empInfo.openId,
          name: name,
          company:company,
          phone:phone,
          email:email,
          address:address,
          type:p.typeIds[typeId],
          toEmail:p.typeEmails[typeId] ,
          typeName:typeName,
          content:content,
          subjectName:"相关问询"
        }
          $("#save").css("pointer-events", "none");
          $.modal({
              title: "",
              text: '<span class="color-green">提交成功！</span></br>Success',
              buttons: [{
                text: "确定OK",
                onClick:function(){
                  location.href="feedback-inquiries.html?appid="+cfApp.getQueryString("appid")+"&id="+cfApp.getQueryString("id");
                }
              }]
          });
        G.ajax(G.devModePost, p.params.dataApi, formdata, function (retdata) {
            $("#save").css("pointer-events", "inherit");
          // if (retdata.errorNo == '0') {
          //   //注册成功
          //   $.modal({
          //     title: "",
          //     text: '<span class="color-green">提交成功！</span></br>Success',
          //     buttons: [{
          //       text: "确定OK",
          //       onClick:function(){
          //         location.href="feedback-inquiries.html?appid="+cfApp.getQueryString("appid")+"&id="+cfApp.getQueryString("id");
          //       }
          //     }]
          //   });
          // } else if (retdata.errorNo == '1') {
          //   $.modal({
          //       title: "",
          //       text: '<span class="color-green">获取异常！</span></br>System error',
          //       buttons: [{
          //         text: "确定OK"
          //       }]
          //     });
          // }
          // else if (retdata.errorNo == '2') {
          //   $.modal({
          //       title: "",
          //       text: '<span class="color-green">参数错误！</span></br>Parameter  error',
          //       buttons: [{
          //         text: "确定OK"
          //       }]
          //     });
          // }
          // else if (retdata.errorNo == '3') {
          //   $.modal({
          //       title: "",
          //       text: '<span class="color-green">验证码不正确！</span></br>The phone number is occupied',
          //       buttons: [{
          //         text: "确定OK"
          //       }]
          //     });
          // }
          // else if (retdata.errorNo == '4') {
          //   $.modal({
          //       title: "",
          //       text: '<span class="color-green">手机号被占用！</span></br>System error',
          //       buttons: [{
          //         text: "确定OK"
          //       }]
          //     });
          // }
          // else if (retdata.errorNo == '5') {
          //   $.modal({
          //       title: "",
          //       text: '<span class="color-green">此openId已注册！</span></br>The openId is registered',
          //       buttons: [{
          //         text: "确定OK"
          //       }]
          //     });
          // }

        })



      })
    }


  };

  return Register;
})();