package com.cftech.base.org.utils;

import com.alibaba.fastjson.JSONArray;
import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.service.QyuserService;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.Constants;
import com.cftech.core.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * redis 缓存类
 * Created by 16444 on 2020/10/19.
 */
@Slf4j
@Component
public class RedisCacheUtils {

    @Autowired
    private RedisTemplate<String, String> redisTemplates;

    @Autowired
    private QyuserService qyuserService;

    private RedisTemplate<String, String> getConfig() {
        StringRedisSerializer strSerializer = new StringRedisSerializer();
        redisTemplates.setKeySerializer(strSerializer);
        redisTemplates.setHashKeySerializer(strSerializer);
        redisTemplates.setHashValueSerializer(strSerializer);
        //redisTemplate.setValueSerializer(stringSerializer);
        return redisTemplates;
    }

    /**
     * 获取轮询的药师，医生
     * @return
     */
    public String findPollingUsers() {
        //获取药师队列

        //获取医生队列
        return "";
    }

    public String findPollingDoctor(String accountsId) {
        JSONArray doctors = null;
        String doctorKey = "DOCTOR_QUEUE_" + accountsId;
        if (getConfig().hasKey(doctorKey)) {
            String userStr = getConfig().opsForValue().get(doctorKey).toString();

            if (StringUtils.isBlank(userStr)) {
                List<Qyuser> users = qyuserService.fetchPollingData("1");
                StringBuffer ids = new StringBuffer();
                users.stream().forEach(user ->  ids.append(user.getId()+",") );

            }

            //doctors = JSONArray.parseArray(userArr);
        }

        return "";
    }

    public String findPollingCusService() {
        return "";
    }
}
