package com.cftech.activity.giftbox.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.giftbox.model.Giftbox;
import com.cftech.activity.giftbox.service.GiftboxService;
import com.cftech.activity.log.model.GiftboxLog;
import com.cftech.activity.log.service.GiftboxLogService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.DateFormatUtils;
import com.cftech.questionnaire.core.paper.model.PaperBaseEntity;
import com.cftech.questionnaire.core.paper.model.PaperLog;
import com.cftech.questionnaire.core.paper.service.PaperLogService;
import com.cftech.questionnaire.core.paper.service.PaperService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2017/4/26 0026.
 *
 * @author strive
 *         手机端拆礼盒接口
 */
@RestController
@RequestMapping("/mobile/auth/giftbox")
@Slf4j
public class MobileGiftboxController {

    @Autowired
    private GiftboxLogService giftboxLogService;

    @Autowired
    private GiftboxService giftboxService;

    @Autowired
    private PaperService paperService;

    @Autowired
    private PaperLogService paperLogService;




    /**
     * 获取拆礼盒活动详情接口
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/detail/{id}/{openId}", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject detail(@PathVariable("id") Long id,@PathVariable("id") Long openId) {

        JSONObject rtnJson = new JSONObject();

        try {
            Giftbox giftbox = giftboxService.fetchById(id);
            Conds conds = new Conds();
            conds.equal("m.open_id",openId);
            conds.equal("wl.activity_id",id);

            if(giftbox!=null){

                int count=giftboxLogService.count(conds);
                giftbox.setPlayCount(count);
                conds.equal("date(t.create_time)", DateFormatUtils.getDateFormat(new Date(),"yyyy-MM-dd"));

                int nowCount=giftboxLogService.count(conds);
                giftbox.setNowPlayCount(nowCount);
            }
            rtnJson.put("errorNo", 0);
            rtnJson.put("data", giftbox);
        } catch (Exception e) {
            log.error("获取活动详情出现异常:" + e.getMessage());
            rtnJson.put("errorNo", 1);
        }

        return rtnJson;
    }

    @RequestMapping(value = "/play/{id}/{openId}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject play(@PathVariable("id") Long id, @PathVariable("openId") String openId , Long meetingId) {
        JSONObject rtnJson = new JSONObject();

        try {
            Conds conds = new Conds();
            conds.equal("activity_type",0);
            conds.equal("activity_id",id);
            conds.equal("del_flag",0);
            Sort sort = new Sort("create_time", OrderType.DESC);
            List<PaperBaseEntity> list = paperService.fetchSearchByPage(conds,sort,0,0);
            if(list!=null && list.size()>0){   //该活动已经绑定问卷
                for(PaperBaseEntity paperBaseEntity : list){
                    Conds condslog = new Conds();
                    condslog.equal("palyer_id",openId);
                    condslog.equal("del_flag",0);
                    condslog.equal("paper_id",paperBaseEntity.getId());
                    Sort sortlog = new Sort("create_time",OrderType.DESC);
                    List<PaperLog> listlog = paperLogService.fetchSearchByPage(condslog,sortlog,0,0);
                    if(listlog==null || listlog.size()==0){  //改玩家没填问卷
                        rtnJson.put("errorNo",6);  //没有填问卷不能玩
                        return rtnJson;
                    }

                }
            }
            Giftbox giftbox = giftboxService.fetchById(id);
            giftbox.setPrizes(HtmlUtils.htmlUnescape(giftbox.getPrizes()));
            giftbox.setMeetingId(meetingId);
            rtnJson= giftboxService.play(openId, giftbox);
            if(!rtnJson.getString("errorNo").equals("1")) {
                GiftboxLog giftboxLog = new GiftboxLog();
                giftboxLog.setDelFlag(false);
                giftboxLog.setAccountsId(giftbox.getAccountsId());
                giftboxLog.setActivityId(giftbox.getId());
                giftboxLog.setFrom(giftbox.getClass().getSimpleName());
                giftboxLog.setOpenId(openId);
                giftboxLog.setTitle(giftbox.getTitle());
                if(meetingId!=null){
                    giftboxLog.setDescription(meetingId.toString());
                }
                giftboxLogService.save(giftboxLog);
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo",1);
            rtnJson.put("errorMsg","系统异常");
            log.error("玩游戏出现异常:" + e.getMessage());
        }
        return rtnJson;
    }


}
