package com.cftech.showroom.sdepartment.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.poi.OnReadDataHandler;
import com.cftech.showroom.sdepartment.model.Sdepartment;
import com.cftech.showroom.sdepartment.service.SdepartmentService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.showroom.visitorCategory.model.VisitorCategory;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 展厅申请部门Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String SDEPARTMENT_VIEW = "qy:sdepartment:view"
 * 查看:public static final String SDEPARTMENT_EDIT = "qy:sdepartment:edit"
 *
 * @author lisw
 * @date: 2019-07-31 15:16
 */
@Slf4j
@Controller
@RequestMapping("/a/sdepartment")
public class SdepartmentController {

    public static final String SDEPARTMENT_VIEW = "qy:sdepartment:view";
    public static final String SDEPARTMENT_EDIT = "qy:sdepartment:edit";

    @Autowired
    private SdepartmentService sdepartmentService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = SDEPARTMENT_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "sdepartment/sdepartmentlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = SDEPARTMENT_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Sdepartment sdepartment = sdepartmentService.fetchById(id);
            model.addAttribute("data", sdepartment);
        }
        return "sdepartment/sdepartmentform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = SDEPARTMENT_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Sdepartment sdepartment, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (sdepartment != null && sdepartment.getId() != null) {
                sdepartment.setUpdateBy(UserUtils.getUser().getId());
                sdepartmentService.update(sdepartment);
                rtnJson.put("errorNo", 0);
            } else {
                sdepartment.setNumber(codingruleUtils.getNumber(accountsId, Sdepartment.class.getName()));
                sdepartment.setAccountsId(accountsId);
                sdepartment.setDelFlag(false);
                sdepartment.setAccountsId(UserUtils.getmpaccounts(request));
                sdepartment.setCreateBy(UserUtils.getUser().getId());
                sdepartment.setUpdateBy(UserUtils.getUser().getId());
                sdepartmentService.save(sdepartment);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = SDEPARTMENT_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Sdepartment sdepartment, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(sdepartment.getNumber())) {
            conds.like("number", sdepartment.getNumber());
        }
        if (!StringUtils.isEmpty(sdepartment.getName())) {
            conds.like("name", sdepartment.getName());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Sdepartment> list = sdepartmentService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = sdepartmentService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = SDEPARTMENT_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            sdepartmentService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }


    //下载模板
    @RequestMapping(value = "/templateExcel", method = {RequestMethod.GET, RequestMethod.POST})
    @RequiresPermissions(value = SDEPARTMENT_VIEW)
    @ResponseBody
    public void templateExcel(HttpServletRequest request, HttpServletResponse response, Sdepartment sdepartment) {
        // 生成Excel并使用浏览器下载

        ExcelKit.$Export(Sdepartment.class, response).toExcel(null, "展厅申请部门信息");
    }


    @RequestMapping(value = "/exportExcel", method = {RequestMethod.GET, RequestMethod.POST})
    @RequiresPermissions(value = SDEPARTMENT_VIEW)
    @ResponseBody
    public void exportInviteCodeExcel(HttpServletRequest request, HttpServletResponse response, Sdepartment sdepartment) {
        // 生成Excel并使用浏览器下载
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(sdepartment.getNumber())) {
            conds.like("number", sdepartment.getNumber());
        }
        if (!StringUtils.isEmpty(sdepartment.getName())) {
            conds.like("name", sdepartment.getName());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Sdepartment> list = sdepartmentService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(Sdepartment.class, response).toExcel(list, "展厅申请部门信息");
    }


    //导入
    @RequestMapping(value = "/importExcel", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    @RequiresPermissions(value = SDEPARTMENT_EDIT)
    public JSONObject importExcel(HttpServletRequest request, MultipartFile file, Model model, Long id) {
        JSONObject retJson = new JSONObject();
        Long accountId = UserUtils.getmpaccounts(request);
        Long userId = UserUtils.getUser().getId();
        StringBuffer stringBuffer = new StringBuffer();
        if (file == null) {
            retJson.put("errorNo", "1");
            retJson.put("errorMsg", "未选择导入文件");
            return retJson;
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue(null).readExcel(storeFile, rowData -> {
                    Sdepartment sdepartment = new Sdepartment();
                    if (!StringUtils.isEmpty(rowData.get(0))) {
                        sdepartment.setName(rowData.get(0));
                    }
                    if (!StringUtils.isEmpty(rowData.get(1))) {
                        sdepartment.setSort(rowData.get(1));
                    }
                    sdepartment.setAccountsId(accountId);
                    sdepartment.setCreateBy(userId);
                    sdepartment.setUpdateBy(userId);
                    sdepartmentService.save(sdepartment);
            });
        } catch (IOException e) {
//            e.printStackTrace();
            log.error(e.getMessage());
        }
        retJson.put("errorNo", "0");
        retJson.put("errorMsg", "导入成功");
        return retJson;
    }

}
