package com.cftech.common.typeappform.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.common.cancelitems.model.Cancelitems;
import com.cftech.common.grantitems.model.Grantitems;
import com.cftech.core.poi.ExportConfig;
import com.cftech.core.util.StringUtils;
import lombok.Data;
import lombok.experimental.Accessors;
import org.owasp.esapi.ESAPI;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 类型申请单
 *
 * @author faye
 * @date: 2019-08-14 16:52
 */
@Data
@Accessors(chain = true)
public class TypeAppForm implements Serializable {

    private List<Grantitems> grantitems;

    private List<Cancelitems> cancelitems;

    @ExportConfig(value = "序号", width = 100)
    private Long serialNumber;
    /**
     * 申请人
     */
    @ExportConfig(value = "申请人", width = 100)
    private String name;

    private Long department;
    /* 职能部门 */
    @ExportConfig(value = "部门", width = 100)
    private String dname;


    @ExportConfig(value = "ORG", width = 100)
    private String org;

    /* 创建时间 */
    @ExportConfig(value = "申请时间", width = 100,dateFormat = "yyyy-MM-dd HH:mm")
    private Date createTime;

    private Long approver;//审批人


    @ExportConfig(value = "审批人", width = 100)
    private String aname;


    /*发放状态*/
    private String issuingState;


    private String items;//实际发放促销品明细（固化）

    @ExportConfig(value = "申请促销品明细", width = 100)
    private String itemsName;//实际发放促销品明细（固化）

    @ExportConfig(value = "Legal Entity", width = 100)
    private String legalEntity;//申请促销品明细
    /* 成本中心 */
    @ExportConfig(value = "成本中心", width = 100)
    private String costCenter;

    //申请总金额
    private String appPrice;

    //实际发放总金额(固化)
    @ExportConfig(value = "总金额", width = 100)
    private String totalPrice;

    private String useId;
    /*使用用途*/

    @ExportConfig(value = "支出类别", width = 100)
    private String uname;

    @ExportConfig(value = "对应申请单号", width = 100)
    private String number;

    /*申请备注*/
    @ExportConfig(value = "备注", width = 100)
    private String remarks;


    /* 主键id */
    private Long id;
    /* 申请人OPENID */

    /* 申请人ORG */



    /* 发放地址 */
    @ExportConfig(value = "发放地址", width = 100)
    private String address;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 发货方  0仅供应商  1仅管理员  2供应商管理员同时 */
    private String grantSource;
    /* 供应商发货金额*/
    private String disTotalPrice;
    /* 管理员物流金额*/
    private String totalLogisticsPrice;//暂时废弃，管理员发货不需要输入物流金额
    /* 供应商物流金额*/
    private String disLogisticsPrice;
    /*管理员物流信息*/
    private String logisticsOrderInfo;
    /*供应商物流信息*/
    private String disLogisticsOrderInfo;
    /*管理员发货备注*/
    private String grantRemarks;
    /*供应商发货备注*/
    private String disGrantRemarks;
    /*管理员录入数量备注*/
    private String managerSubmitRemarks;

    /**
     * 发货时间
     */
    private String managerGrantTime;
    private String disGrantTime;
    private String allGrantTime;











    //0:待部门领导审批  1:部门领导已审批通过 2：部门领导已审批拒绝 3：市场部领导审批中  4：市场部领导已审批通过  5：市场部领导已审批拒绝
    @ExportConfig(value = "审批状态", width = 100)
    private String statusName;

    //0：未发放  1：已发放
    @ExportConfig(value = "发放状态", width = 100)
    private String issuingStateName;

    private String isCancel;  //是否有退库  0:未退库  1:有退库



    public void setStatus(String status) {
        this.status = status;
        switch (status){
            case "0":
                this.statusName ="职能部门领导审批中";
                break;
            case "1":
                this.statusName = "职能部门领导已审批(通过)";
                break;
            case "2":
                this.statusName = "职能部门领导已审批(拒绝)";
                break;
            case "3":
                this.statusName = "职能部门领导已审批(通过)，待市场部领导审批中";
                break;
            case "4":
                this.statusName = "职能部门领导已审批(通过)，市场部领导已审批(通过)";
                break;
            case "5":
                this.statusName = "职能部门领导已审批(通过)，市场部领导已审批(拒绝)";
                break;
        }
    }

    public void setIssuingState(String issuingState) {
        this.issuingState = issuingState;
        switch (issuingState){
            case "-1":
                if(this.status.equals("2")){
                    this.issuingStateName = "无需发放";
                }else{
                    this.issuingStateName = "待录入数量";
                }
                break;
            case "0":
                this.issuingStateName ="已录入,未发货";
                break;
            case "1":
                this.issuingStateName = "供应商已发货";
                break;
            case "2":
                this.issuingStateName = "管理员已发货";
                break;
            case "3":
                this.issuingStateName = "全部已发货";
                break;

        }
    }



    /**
     * 填充
     * @param items
     */
    public void setItems(String items) {
        this.items = items;
        if(StringUtils.isNotBlank(items)){
            JSONArray array = JSON.parseArray(ESAPI.encoder().decodeForHTML(items));
            StringBuffer stringBuffer = new StringBuffer();
            for(int i =0;i<array.size();i++){
                JSONObject obj = array.getJSONObject(i);
                 String name = obj.getString("name");
                 String num  = obj.getString("num");
                 stringBuffer.append(name+"*"+num+"; "+"\r\n");
            }

            this.itemsName = stringBuffer.toString();
        }
    }

    private Long typeform;

    private String typeformName;

    /* 更新时间 */
    private Date updateTime;
    /* 发放备注 */
    @ExportConfig(value = "发放备注", width = 100)
    private String description;

    @ExportConfig(value = "申请人OPENID", width = 100)
    private String openid;


    private String cItems;

    @ExportConfig(value = "退库明细", width = 100)
    private String cancelItemsNames;

    @ExportConfig(value = "退款原因", width = 100)
    private String cancelItemsDescNames;

    private String pdfpath;

    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;


    private BigDecimal cancelTotalPrice;

    private Integer managerAllEvaluate;

    private Integer managerQualityEvaluate;

    private Integer managerLogisticsEvaluate;

    private String managerEvaluateRemarks;

    private Integer applyAllEvaluate;

    private Integer applyQualityEvaluate;

    private Integer applyLogisticsEvaluate;

    private String applyEvaluateRemarks;

    //管理员评价时间
    private Date  managerQualityTime;
    //申请人评价时间
    private Date applyQualityTime;

    //管理员确认收货时间
    private Date managerConfirmTime;


    public void setcItems(String cItems) {
        if(StringUtils.isNotBlank(cItems)){
            this.issuingStateName="已发放,但有退库";
            JSONArray array = JSON.parseArray(ESAPI.encoder().decodeForHTML(cItems));
            String desc = "";
            String cancelDetails = "";
            cancelTotalPrice = new BigDecimal("0");
            for(int i=0;i<array.size();i++){
                JSONObject obj = array.getJSONObject(i);
                int num = i+1;
                desc+=num+":"+obj.getString("desc");
                JSONArray itemsArray = obj.getJSONArray("datas");
                cancelDetails+=num+":(";
                for(int k=0;k<itemsArray.size();k++){
                    JSONObject itemObj = itemsArray.getJSONObject(k);
                    Integer count =itemObj.getInteger("count");
                    String price = itemObj.getString("price");
                    BigDecimal priceBig = new BigDecimal(price);
                    BigDecimal countBig = new BigDecimal(count);
                    BigDecimal bigDecimalT = (priceBig.multiply(countBig)).setScale(2, BigDecimal.ROUND_HALF_UP);
                    cancelTotalPrice = cancelTotalPrice.add(bigDecimalT).setScale(2,BigDecimal.ROUND_HALF_UP);
                    cancelDetails+=itemObj.getString("name")+"*"+itemObj.getString("count");
                    if(k<itemsArray.size()-1){
                        cancelDetails+=";"+"\r\n";
                    }
                }
                cancelDetails+=")";
                if(i<array.size()-1){
                    desc+=",";
                    cancelDetails+=",";
                }
            }
            this.cancelItemsDescNames=desc;
            this.cancelItemsNames=cancelDetails;
        }
        this.cItems = cItems;
    }

    public TypeAppForm() {
        this.delFlag = false;
    }

}
