package com.cftech.cms.specialarticle.service.impl;

import com.cftech.cms.specialarticle.dao.SpecialArticleMapper;
import com.cftech.cms.specialarticle.model.SpecialArticle;
import com.cftech.cms.specialarticle.service.SpecialArticleService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * CMS专题文章管理ServiceImpl
 *
 * @author lisw
 * @date: 2017-05-04 10:03
 */
@Service("specialArticleService")
public class SpecialArticleServiceImpl extends GenericServiceImpl<SpecialArticle> implements SpecialArticleService {

    @Autowired
    @Qualifier("specialArticleMapper")
    private SpecialArticleMapper specialArticleMapper;

    @Override
    public GenericDao<SpecialArticle> getGenericMapper() {
        return specialArticleMapper;
    }

    @Override
    public String getSpecialArticle(Long id) {
        return specialArticleMapper.getSpecialArticle(id);
    }

    @Override
    public int saveBatchSpecialArticle(Long specialId, String[] articles) {
        specialArticleMapper.removeSpecial(specialId);
        if (articles != null && articles.length > 0 && !StringUtils.isEmpty(articles[0])) {
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("specialId", specialId);
            params.put("articles", articles);
            return specialArticleMapper.saveBatchSpecialArticle(params);
        } else {
            return 1;
        }
    }
}