package com.cftech.reportform.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 报表管理
*
* @author Licc
* @date: 2020-10-16 14:33
*/
@Data
public class ReportForm implements Serializable {
    /*药师名称*/
    @ExportConfig(value = "药师名称", width = 100, showLevel = 1)
    private String pharmacist;
    /*客服名称*/
    @ExportConfig(value = "客服名称", width = 100, showLevel = 1)
    private String customerName;
    /*订单编号*/
    @ExportConfig(value = "订单编号", width = 100, showLevel = 1)
    private String orderCode;
    /*订单金额*/
    @ExportConfig(value = "订单金额", width = 100, showLevel = 1)
    private Double orderAmount;
    /*咨询单号*/
    @ExportConfig(value = "咨询单号", width = 100, showLevel = 1)
    private String numberCode;
    /*物流单号 */
    @ExportConfig(value = "物流单号", width = 100, showLevel = 1)
    private String logisticsCode;
    /*物流状态*/
    @ExportConfig(value = "物流状态", width = 100, showLevel = 1)
    private Long logisticsStatus;

    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;


}