package com.cftech.accounts.dao;

import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.core.generic.GenericDao;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;
import java.util.Map;


public interface MpAccountsMapper extends GenericDao<MpAccountsEntity> {
	
    @CacheEvict(value = { "mpAccounts"},key="#p0.getAppid().toString()")
    long insert(MpAccountsEntity mpAccounts); 
	
	//@Cacheable(value="mpAccounts",key="#p0.toString()")
	List<MpAccountsEntity> getMpAccounts(Long userid);

	List<MpAccountsEntity> getQyAccounts(Long userid);
    
	
	//@Cacheable(value="countmpAccounts" )
	//Long allUserscounts(Page<MpAccountsEntity> page);
    
	//更新账户 信息
	@CacheEvict(value = { "mpAccounts"},key="#p0.getAppid().toString()")
	long updateByPrimaryKey(MpAccountsEntity mpAccounts);
	
	
	//删除账户
	@Cacheable(value="mpAccounts",key="#p0.toString()")
	int deleteByPrimaryKey(Long id);

	
	//@Cacheable(value="detail",key="#p0.toString()")
	MpAccountsEntity getDetail(Long userid);
	
	List<MpAccountsEntity> getAllMpAccounts();

	List<MpAccountsEntity> getAllQyAccounts();
	
	@Cacheable(value="mpAccounts",key="#p0.toString()")
	MpAccountsEntity getMpAccountsAppid(String appId);
	
	int deleteByUserAccount(Map<String, Object> params);
	
	int insertUserAccount(Map<String, Object> params);
	
	int getUserAccounts(Map<String, Object> params);
}
