package com.cftech.cos.uploader;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import com.cftech.cos.core.CosService;

import java.io.InputStream;
import java.util.UUID;

/**
 * Created by liuling on 2017/5/3.
 */
public class CosFileUploader {

    private CosService cosService;
    private Cosconfig cosconfig;

    public CosFileUploader(Cosconfig cosconfig, CosService cosService) {
        this.cosService = cosService;
        this.cosconfig = cosconfig;
    }


    /**
     * 上传文件
     *
     * @param data  上传的数据
     * @param format 文件扩展名称
     * @return
     * @throws Exception
     */
    public JSONObject uploadFile(byte[] data, String format) throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (cosconfig == null) {
            jsonObject.put("code", "1");
            jsonObject.put("message", "cos config not init");
            return  jsonObject;

        }


        String uuid = UUID.randomUUID().toString();
        String target = uuid + "." + format;
        String httpBase = cosconfig.getUrl();
        if(!httpBase.endsWith("/")) {
            httpBase += "/";
        }
        JSONObject retObj = cosService.uploadFile(cosconfig, data, target);
        if (retObj.getString("code").equals("0")) {
            jsonObject.put("code", "0");
            jsonObject.put("key", target);
            jsonObject.put("url",httpBase + target);
            return jsonObject;
        } else {
            jsonObject.put("code", "1");
            return jsonObject;
        }
    }

    public JSONObject uploadFile(InputStream inputStream, String format) throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (cosconfig == null) {
            jsonObject.put("code", "1");
            jsonObject.put("message", "cos config not init");
            return  jsonObject;

        }
        String uuid = UUID.randomUUID().toString();
        String target = uuid + "." + format;
        String httpBase = cosconfig.getUrl();
        if(!httpBase.endsWith("/")) {
            httpBase += "/";
        }
        JSONObject retObj = cosService.uploadFile(cosconfig, inputStream, target);
        if (retObj.getString("code").equals("0")) {
            jsonObject.put("code", "0");
            jsonObject.put("key", target);
            jsonObject.put("url",httpBase + target);
            return jsonObject;
        } else {
            jsonObject.put("code", "1");
            return jsonObject;
        }

    }

    public JSONObject deleteFile(String key) throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (cosconfig == null) {
            jsonObject.put("code", "1");
            jsonObject.put("message", "cos config not init");
            return  jsonObject;

        }
        JSONObject retObj = cosService.deleteFile(cosconfig, key);
        if (retObj.getString("code").equals("0")) {
            jsonObject.put("code", "0");
            return jsonObject;
        } else {
            jsonObject.put("code", "1");
            return jsonObject;
        }

    }



}
