package com.cftech.invoice.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.invoice.model.InvoiceDetail;
import com.cftech.invoice.service.InvoiceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@RequestMapping("mobile/data/invoice")
public class MobileInvoiceController {

    @Autowired
    private InvoiceService invoiceService;

    /**
     * 查看发票详情接口
     * @param invoiceDetail (传订单ID  和appId)
     * @return
     */
    @RequestMapping(value = "/invoiceDetail", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject invoiceDetail (@RequestBody InvoiceDetail invoiceDetail){
        return invoiceService.selectInvoiceDetail(invoiceDetail);
    }

}
