package com.cftech.shop.qrcode.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 二维码
 *
 * @author Neil
 * @date: 2017-12-04 17:56
 */
@Data
public class WxQrcode implements Serializable {

    /* 主键id */
    private Long id;
    /* 所属组织Id */
    private Long orgId;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 场景值 */
    private String sceneId;
    /* 二维码类别 1:药师；2:客服；3：医生；4：组织*/
    private String type;
    /* 二维码的Ticket */
    private String ticket;
    /* 绑定的Id */
    private Long bindId;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    /* 绑定对象 */
    private String qrcodeNames;

    /**
     * 绑定对象显示的名字
     */
    private String objectName;

    public WxQrcode() {
        this.delFlag = false;
        this.status = "0";
    }

}