package com.cftech.productdetail.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 产品详情
 *
 * @author Buyj
 * @date: 2020-09-28 17:08
 */
@Data
public class ProductDetail implements Serializable {

    /* 主键id */
    private Long id;
    /* 产品详情编码 */
    @ExportConfig(value = "产品详情编码", width = 150, showLevel = 1)
    private String productDetailNumber;
    /* 物料编码 */
    @ExportConfig(value = "物料编码", width = 100, showLevel = 1)
    private String materielNumber;
    /* 产品编码 */
    @ExportConfig(value = "产品编码", width = 100, showLevel = 1)
    private String productNumber;
    /* 产品名称 */
    @ExportConfig(value = "产品名称", width = 100, showLevel = 1)
    private String productName;
    /* 产品分类编码 */
    @ExportConfig(value = "产品分类编码", width = 150, showLevel = 1)
    private String productClassifyNumber;
    /* 入库编码 */
    @ExportConfig(value = "入库编码", width = 100, showLevel = 1)
    private String intoWareroomNumber;
    /* 出库编码 */
    @ExportConfig(value = "出库编码", width = 100, showLevel = 1)
    private String outWareroomNumber;
    /* 订单编码 */
    @ExportConfig(value = "订单编码", width = 100, showLevel = 1)
    private String orderNumber;
    /* 物流编码 */
    @ExportConfig(value = "物流编码", width = 100, showLevel = 1)
    private String logisticsNumber;
    /* 是否出售 */
    @ExportConfig(value = "是否出售", width = 100, showLevel = 1)
    private String whetherSell;
    /**
     * 出库时间
     */
    @ExportConfig(value = "出库时间", width = 100, showLevel = 1)
    private Date outWareroomTime;
    /**
     * 产品图片
     */
    private String productImg;
    /**
     * 产品分类名称
     */
    private String classifyName;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public ProductDetail() {
        this.delFlag = false;
        this.status = "0";
    }

}