var scheduleList = (function () {
  'use strict';
  var ScheduleList = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/detailes/getdetails',

      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/my-schedule-list.json';


    }

    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);
    Handlebars.registerHelper({
      'datetimeformat': function (t) {
        var date = new Date(t);
        return dataUtils.dateFormat(date, 'yyyy-MM-dd')
      }
    });

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {
        var sideDiv = new side({
          currentIndex: '7',
          cfApp: cfApp

        });
        sideDiv.init();
        log();
        loadData();
        $('.language').click(function () {
          if(!p.english){
location.href = 'my-schedule-list-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
          }else{
location.href = 'my-schedule-list.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
          }
          
        });
        $('#submit').click(function () {
          if (p.english) {
            location.href = 'my-schedule-form-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
          } else {
            location.href = 'my-schedule-form.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
          }

        });


        return true;
      } else {
        return false;
      }
    };
    var log = function () {

      var formdata = {
        openid: p.empInfo.openId,
        module: "研讨会",
        modulename: "我的行程",
        keyword: "我的行程",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {
      if(p.english){
        $.showLoading("Loading");
      }else{
        $.showLoading();
      }

      var formdata = {

        meetingId: cfApp.getQueryString('id'),
        member_uid: p.empInfo.memberId
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        var str = null;
        if(p.english){
          str = '<span class="color-green">Please submit your schedule first!';
        }else{
          str = '<span class="color-green">暂无行程，去更新行程！';
        }
        if (retdata.errorNo == '0') {
          var detailsinfo = retdata.detailsinfo;
          if (!detailsinfo || detailsinfo == '') {
            $.modal({
              title: "",
              text: str,
              buttons: [{
                text: "确定OK",
                onClick: function () {

                  if(p.english){
                    location.href = 'my-schedule-form-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+'&english=1';
                  }else{
                    location.href = 'my-schedule-form.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
                  }

                }
              }]
            });
            return false;
          }
          var serviceInfo = retdata.service;
          serviceInfo=JSON.parse(serviceInfo);
          detailsinfo = JSON.parse(detailsinfo);
          detailsinfo.isHotel = detailsinfo.isHotel == 0 ? true : false;
          detailsinfo.isEat = detailsinfo.isEat == 0 ? true : false;
          detailsinfo.isRelay = detailsinfo.isRelay == 0 ? true : false;
          detailsinfo.isTake = detailsinfo.isTake == 0 ? true : false;
          detailsinfo.isfactory = detailsinfo.isfactory == 0 ? true : false;
          if(detailsinfo.isHotel){
            detailsinfo.hotel = JSON.parse(detailsinfo.hotel);
            var serviceHotel = JSON.parse(serviceInfo.hotel);
            for(var i =0;i<serviceHotel.length;i++){
              if(serviceHotel[i].title == detailsinfo.hotel.title){
                detailsinfo.hotel.titleEn = serviceHotel[i].titleEn;
                detailsinfo.hotel.hoteladrressEn = serviceHotel[i].hoteladrressEn;
              }
            }
          }
          if( detailsinfo.isEat){
            detailsinfo.eat = JSON.parse(detailsinfo.eat);
            var serviceEat = JSON.parse(serviceInfo.eat);
            for(var k = 0;k<detailsinfo.eat.length;k++){
              for(var i =0;i<serviceEat.length;i++){
                if(serviceEat[i].eatname == detailsinfo.eat[k].eatname){
                  detailsinfo.eat[k].eatname = serviceEat[i].eatname;
                  detailsinfo.eat[k].eatnameEn = serviceEat[i].eatnameEn;
                }
              }
            }
          }
          if(detailsinfo.isRelay){
            detailsinfo.relay = JSON.parse(detailsinfo.relay);
            var relay = detailsinfo.relay;
            detailsinfo.send = JSON.parse(detailsinfo.send);
            detailsinfo.relay.isOnedrive = detailsinfo.relay.isOnedrive == 0 ? true : false;
            detailsinfo.relay.isOther = detailsinfo.relay.isOther == 0 ? true : false;
            detailsinfo.relay.isHigh = detailsinfo.relay.isHigh == 0 ? true : false;
            detailsinfo.relay.isPlane = detailsinfo.relay.isPlane == 0 ? true : false;
            detailsinfo.send.isOnedrive = detailsinfo.send.isOnedrive == 0 ? true : false;
            detailsinfo.send.isOther = detailsinfo.send.isOther == 0 ? true : false;
            detailsinfo.send.isHigh = detailsinfo.send.isHigh == 0 ? true : false;
            detailsinfo.send.isPlane = detailsinfo.send.isPlane == 0 ? true : false;
            var serviceRelay = JSON.parse(serviceInfo.relay);
            if(detailsinfo.send.isPlane){
              var planeArray = serviceRelay.plane;
              for(var i=0;i<planeArray.length;i++){
                if(planeArray[i].planesattion==detailsinfo.send.plane.planesattion){
                  detailsinfo.send.plane.planesattionEn=planeArray[i].planesattionEn;
                }
              }
            }
            if(detailsinfo.send.isHigh){
              var highArray = serviceRelay.high;
              for(var i=0;i<highArray.length;i++){
                if(highArray[i].highsattion==detailsinfo.send.high.highsattion){
                  detailsinfo.send.high.highsattionEn=highArray[i].highsattionEn;
                }
              }
            }
            if(detailsinfo.relay.isPlane){
              var planeArray = serviceRelay.plane;
              for(var i=0;i<planeArray.length;i++){
                if(planeArray[i].planesattion==detailsinfo.relay.plane.planesattion){
                  detailsinfo.relay.plane.planesattionEn=planeArray[i].planesattionEn;
                }
              }
            }
            if(detailsinfo.relay.isHigh){
              var highArray =serviceRelay.high;
              for(var i=0;i<highArray.length;i++){
                if(highArray[i].highsattion==detailsinfo.relay.high.highsattion){
                  detailsinfo.relay.high.highsattionEn=highArray[i].highsattionEn;
                }
              }
            }
          }
          if(detailsinfo.isTake){
            detailsinfo.take = JSON.parse(detailsinfo.take);
            var serviceTake = JSON.parse(serviceInfo.take);
            for(var k=0;k<detailsinfo.take.length;k++){
              for(var i=0;i<serviceTake.length;i++){
                if(serviceTake[i].taketime == detailsinfo.take[k].taketime){
                  detailsinfo.take[k].taketime = serviceTake[i].taketime+" "+serviceTake[i].take_des;
                  detailsinfo.take[k].taketimeEn = serviceTake[i].taketime+" "+serviceTake[i].take_des_en;
                }
              }
            }

          }
          if(detailsinfo.isfactory){
            var serviceFactory = JSON.parse(serviceInfo.factory);
            detailsinfo.factory = JSON.parse(detailsinfo.factory);
            for(var k = 0;k<detailsinfo.factory.length;k++){
              for(var i =0;i<serviceFactory.length;i++){
                if(serviceFactory[i].visittime == detailsinfo.factory[k].visittime&&serviceFactory[i].des==detailsinfo.factory[k].visitdesc){
                  detailsinfo.factory[k].visittime = serviceFactory[i].visittime+" "+serviceFactory[i].des;
                  detailsinfo.factory[k].visittimeEn = serviceFactory[i].visittime+" "+serviceFactory[i].des_en;
                }
              }
            }
          }

          // if(relay.isHigh==0){
          //   relay.type='高铁';
//
          // }else if(relay.isPlane==0){
          //   relay.type='飞机';
          //   relay.station=relay.planesattion;
          // }else if(relay.isOnedrive==0){
          //   relay.type='自驾';
          // }if(relay.isOther==0){
          //   relay.type='其他';
          // }
          detailsinfo.isdesc = detailsinfo.desc != '' ? true : false;
          retdata.detailsinfo = detailsinfo;
          console.log(retdata);
          var content = $('#template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata);
          $('.content').append(htmlStr);




        }

      });


    }




  };

  return ScheduleList;
})();