package com.cftech.showroom.appform.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.Constants;
import com.cftech.showroom.appform.model.AppForm;
import com.cftech.showroom.appform.model.ShowroomEvaluate;
import com.cftech.showroom.appform.service.AppFormService;
import com.cftech.showroom.appform.service.ShowroomEvaluateService;
import com.google.gson.JsonObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * @version V1.0
 * @Package com.cftech.showroom.appform.web
 * @Name cftech-platform
 * @Description: TODO 评论
 * @date 2020/6/27
 */
@RestController
@RequestMapping("/mobile/auth/showroom/evaluate")
public class MobileShowroomEvaluateController {

    @Autowired
    ShowroomEvaluateService showroomEvaluateService;

    @Autowired
    AppFormService appFormService;


    /**
     * 保存评论信息
     *
     * @param id
     * @param clothing
     * @param explainMajor
     * @param mediaDevice
     * @param brand
     * @param proposal
     * @return
     */
    @RequestMapping(value = "/submitEvaluate", method = RequestMethod.POST)
    public JSONObject submitEvaluate(Long id, Integer clothing, Integer explainMajor, Integer mediaDevice, Integer brand, String proposal) {
        JSONObject rtnJson = new JSONObject();
        try {
            AppForm appFormExits = appFormService.fetchById(id);
            if (appFormExits == null) {
                rtnJson.put("errorNo", "2");
                return rtnJson;
            }
            Conds evaluateConds = new Conds();
            evaluateConds.equal("t.del_flag", Constants.DEL_FLAG_0);
            evaluateConds.equal("t.showroom_id", id);
            ShowroomEvaluate showroomEvaluate = showroomEvaluateService.fetchSearchByConds(evaluateConds);
            if (showroomEvaluate != null) {
                rtnJson.put("errorNo", "3");
                return rtnJson;
            } else {
                rtnJson.put("errorNo", 0);
                showroomEvaluate = new ShowroomEvaluate();
                showroomEvaluate.setClothing(clothing);
                showroomEvaluate.setExplainMajor(explainMajor);
                showroomEvaluate.setMediaDevice(mediaDevice);
                showroomEvaluate.setBrand(brand);
                showroomEvaluate.setProposal(proposal);
                showroomEvaluate.setShowroomId(id);
                showroomEvaluateService.save(showroomEvaluate);
            }

        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
            e.printStackTrace();
        }
        return rtnJson;
    }

}
