package com.cftech.base.org.service.impl;

import com.cftech.base.org.dao.PositionMapper;
import com.cftech.base.org.model.Position;
import com.cftech.base.org.model.vo.PositionVO;
import com.cftech.base.org.service.PositionService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * positionService
 * Created by Neil 14/02/2017.
 */
@Service("positionService")
public class PositionServiceImpl extends GenericServiceImpl<Position> implements PositionService {

    /**
     * positionMapper
     */
    @Autowired
    @Qualifier("positionMapper")
    private PositionMapper positionMapper;

    @Override
    public GenericDao<Position> getGenericMapper() {
        return positionMapper;
    }

    @Override
    public List<PositionVO> fetchSearchVOByPage(Long positionId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();

        if (positionId == 0) {
            params.put("positionId", positionId);
        } else {
            params.put("positionId", "," + positionId);
        }
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return positionMapper.fetchSearchVOByPage(params);
    }

    @Override
    public List<Position> fetchSearchByPage(Long positionId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        if (positionId == 0) {
            params.put("positionId", positionId);
        } else {
            params.put("positionId", "," + positionId);
        }

        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return positionMapper.fetchSearchByPage(params);
    }

    @Override
    public int count(Long positionId, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        if (positionId == 0) {
            params.put("positionId", positionId);
        } else {
            params.put("positionId", "," + positionId);
        }
        params.put("conds", conds);
        return positionMapper.count(params);
    }

    @Override
    public Position findByAccountIdAndNumber(Long accountId, String number) {
        Conds myCond = new Conds();
        myCond.equal("del_flag", Constants.DEL_FLAG_0);
        myCond.equal("accounts_id", accountId);
        myCond.equal("number", number);

        return fetchSearchByConds(myCond);
    }

	@Override
	public List<Map<String, Object>> getSubordinatePostion(
			Map<String, Object> params) {
		return positionMapper.getSubordinatePostion(params);
	}
}
