package com.cftech.base.org.service.impl;

import com.cftech.base.org.dao.OrgtypeMapper;
import com.cftech.base.org.model.Orgtype;
import com.cftech.base.org.service.OrgtypeService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * orgtypeService
 * Created by Neil 12/02/2017.
 */
@Service("orgtypeService")
public class OrgtypeServiceImpl extends GenericServiceImpl<Orgtype> implements OrgtypeService {

	/**
	 * orgtypeMapper
	 */
	@Autowired
	@Qualifier("orgtypeMapper")
	private OrgtypeMapper orgtypeMapper;

	@Override
	public GenericDao<Orgtype> getGenericMapper() {
		return orgtypeMapper;
	}

	@Override
	public Orgtype findByAccountIdAndNumber(Long accountId, String number) {
		Conds myCond = new Conds();
		myCond.equal("del_flag", Constants.DEL_FLAG_0);
		myCond.equal("accounts_id", accountId);
		myCond.equal("number", number);

		return fetchSearchByConds(myCond);
	}
}
