package com.cftech.questionnaire.core.paperstatic.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.questionnaire.core.paperstatic.model.Paperstatic;
import com.cftech.questionnaire.core.paperstatic.service.PaperstaticService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String PAPERSTATIC_VIEW = "qy:paperstatic:view"
 * 查看:public static final String PAPERSTATIC_EDIT = "qy:paperstatic:edit"
 *
 * @author byj
 * @date: 2018-07-28 14:14
 */
@Slf4j
@Controller
@RequestMapping("/a/paperstatic")
public class PaperstaticController {

    public static final String PAPERSTATIC_VIEW = "qy:paperstatic:view";
    public static final String PAPERSTATIC_EDIT = "qy:paperstatic:edit";

    @Autowired
    private PaperstaticService paperstaticService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = PAPERSTATIC_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "paperstatic/paperstaticlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = PAPERSTATIC_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Paperstatic paperstatic = paperstaticService.fetchById(id);
            model.addAttribute("data", paperstatic);
        }
        return "paperstatic/paperstaticform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = PAPERSTATIC_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Paperstatic paperstatic, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();

        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = PAPERSTATIC_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Paperstatic paperstatic, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        if(!UserUtils.isAdmin()){
            conds.equal("p.create_by", UserUtils.getUser().getId());
        }
        if(!StringUtils.isEmpty(paperstatic.getPaper_title())){
            conds.like("p.paper_title",paperstatic.getPaper_title());
        }
        conds.equal("p.del_flag", Constants.DEL_FLAG_0);
        Sort sort = new Sort("p.create_time", OrderType.DESC);
        List<Paperstatic> list = paperstaticService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = paperstaticService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }
    //导出
    @RequestMapping("/exportExcel")
    @RequiresPermissions(value =  PAPERSTATIC_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,Paperstatic paperstatic) {
        Conds conds = new Conds();
        if(!StringUtils.isEmpty(paperstatic.getPaper_title())){
            conds.like("p.paper_title",paperstatic.getPaper_title());
        }
        conds.equal("p.del_flag", Constants.DEL_FLAG_0);
        Sort sort = new Sort("p.create_time", OrderType.DESC);
        List<Paperstatic> list = paperstaticService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Paperstatic.class, response).toExcel(list, "问卷统计");
    }

    //删除数据
    @RequiresPermissions(value = PAPERSTATIC_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            paperstaticService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
