package com.cftech.mp.qrcode.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.mp.qrcode.model.QrCode;
import com.cftech.mp.qrcode.service.QrCodeService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 微信带参二维码Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String QRCODE_VIEW = "qy:qrCode:view"
 * 查看:public static final String QRCODE_EDIT = "qy:qrCode:edit"
 *
 * @author strive
 * @date: 2017-04-25 11:25
 */
@Slf4j
@Controller
@RequestMapping("/a/qrCode")
public class QrCodeController {

    public static final String QRCODE_VIEW = "mp:qrCode:view";
    public static final String QRCODE_EDIT = "mp:qrCode:edit";

    @Autowired
    private QrCodeService qrCodeService;


    //列表页面
    @RequiresPermissions(value = QRCODE_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "qrCode/qrCodelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = QRCODE_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            QrCode qrCode = qrCodeService.fetchById(id);
            model.addAttribute("data", qrCode);
        }
        return "qrCode/qrCodeform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = QRCODE_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(QrCode qrCode, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (qrCode != null && qrCode.getId() != null) {
                qrCode.setUpdateBy(UserUtils.getUser().getId());
                qrCodeService.update(qrCode);
                rtnJson.put("errorNo", 0);
            } else {
                qrCode.setAccountsId(accountsId);
                qrCode.setDelFlag(false);
                qrCode.setAccountsId(UserUtils.getmpaccounts(request));
                qrCode.setCreateBy(UserUtils.getUser().getId());
                qrCode.setUpdateBy(UserUtils.getUser().getId());
                qrCodeService.save(qrCode);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = QRCODE_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, QrCode qrCode, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accountsid", accountsId);
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<QrCode> list = qrCodeService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = qrCodeService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = QRCODE_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            qrCodeService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
