package com.cftech.cms.distributor_type.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.distributor_type.model.Distributor_type;
import com.cftech.cms.distributor_type.service.Distributor_typeService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String DISTRIBUTOR_TYPE_VIEW = "qy:distributor_type:view"
 * 查看:public static final String DISTRIBUTOR_TYPE_EDIT = "qy:distributor_type:edit"
 *
 * @author byj
 * @date: 2019-03-18 14:49
 */
@Slf4j
@Controller
@RequestMapping("/a/distributor_type")
public class Distributor_typeController {

    public static final String DISTRIBUTOR_TYPE_VIEW = "qy:distributor_type:view";
    public static final String DISTRIBUTOR_TYPE_EDIT = "qy:distributor_type:edit";

    @Autowired
    private Distributor_typeService distributor_typeService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = DISTRIBUTOR_TYPE_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "distributor_type/distributor_typelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = DISTRIBUTOR_TYPE_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Distributor_type distributor_type = distributor_typeService.fetchById(id);
            model.addAttribute("data", distributor_type);
        }
        return "distributor_type/distributor_typeform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = DISTRIBUTOR_TYPE_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Distributor_type distributor_type, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (distributor_type != null && distributor_type.getId() != null) {
                if(!StringUtils.isEmpty(distributor_type.getType_name())){
                    Conds conds = new Conds();
                    conds.equal("type_name",distributor_type.getType_name());
                    conds.equal("del_flag",0);
                    Distributor_type distributor_type1 = distributor_typeService.fetchSearchByConds(conds);
                    if(distributor_type1==null){
                        distributor_type.setUpdateBy(UserUtils.getUser().getId());
                        distributor_typeService.update(distributor_type);
                        rtnJson.put("errorNo", 0);
                    }else{
                        rtnJson.put("errorNo",3);
                    }
                }

            } else {
                distributor_type.setNumber(codingruleUtils.getNumber(accountsId, Distributor_type.class.getName()));
                distributor_type.setAccountsId(accountsId);
                distributor_type.setDelFlag(false);
                distributor_type.setAccountsId(UserUtils.getmpaccounts(request));
                distributor_type.setCreateBy(UserUtils.getUser().getId());
                distributor_type.setUpdateBy(UserUtils.getUser().getId());
                distributor_typeService.save(distributor_type);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = DISTRIBUTOR_TYPE_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Distributor_type distributor_type, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(distributor_type.getType_name())) {
            conds.like("type_name", distributor_type.getType_name());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Distributor_type> list = distributor_typeService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = distributor_typeService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = DISTRIBUTOR_TYPE_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            distributor_typeService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
