package com.cftech.activity.record.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.record.model.OilRecord;
import com.cftech.activity.record.service.OilRecordService;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
* Controller
*
* 权限字符串说明:
* 查看:public static final String OILRECORD_VIEW = "qy:oilRecord:view"
* 查看:public static final String OILRECORD_EDIT = "qy:oilRecord:edit"
*
* @author lisw
* @date: 2017-10-12 17:32
*/
@Slf4j
@Controller
@RequestMapping("/a/oilRecord")
public class OilRecordController {

public static final String OILRECORD_VIEW = "qy:oilRecord:view";
public static final String OILRECORD_EDIT = "qy:oilRecord:edit";

@Autowired
private OilRecordService oilRecordService;
@Autowired
private CodingruleUtils codingruleUtils;


//列表页面
@RequiresPermissions(value = OILRECORD_VIEW)
@RequestMapping("/list")
public String list(HttpServletRequest request, Model model) {
Long accountId = UserUtils.getmpaccounts(request);
model.addAttribute("accountId", accountId);
return "oilRecord/oilRecordlist";
}

//编辑页面（新增、修改）
@RequiresPermissions(value = OILRECORD_VIEW)
@RequestMapping("/form")
public String form(HttpServletRequest request, String id, Model model) {
if (!StringUtils.isEmpty(id)) {
OilRecord oilRecord = oilRecordService.fetchById(id);
model.addAttribute("data", oilRecord);
}
return "oilRecord/oilRecordform";
}

//提交数据（新增、修改）
@RequiresPermissions(value = OILRECORD_EDIT)
@RequestMapping("/formData")
@ResponseBody
public JSONObject formData(OilRecord oilRecord, Model model, HttpServletRequest request) {
Long accountsId = UserUtils.getmpaccounts(request);
JSONObject rtnJson = new JSONObject();
try {
if (oilRecord != null && oilRecord.getId() != null) {
oilRecord.setUpdateBy(UserUtils.getUser().getId());
oilRecordService.update(oilRecord);
rtnJson.put("errorNo", 0);
} else {
    oilRecord.setNumber(codingruleUtils.getNumber(accountsId, OilRecord.class.getName()));
oilRecord.setAccountsId(accountsId);
oilRecord.setDelFlag(false);
oilRecord.setAccountsId(UserUtils.getmpaccounts(request));
oilRecord.setCreateBy(UserUtils.getUser().getId());
oilRecord.setUpdateBy(UserUtils.getUser().getId());
oilRecordService.save(oilRecord);
rtnJson.put("errorNo", 2);
}
} catch (Exception e) {
rtnJson.put("errorNo", 1);
}
return rtnJson;
}

//获取列表数据
@RequiresPermissions(value = OILRECORD_VIEW)
@RequestMapping(value = "/listData")
@ResponseBody
public JSONObject listData(int iDisplayStart, int iDisplayLength, OilRecord oilRecord, HttpServletRequest request) {
Long accountsId = UserUtils.getmpaccounts(request);
Conds conds = new Conds();
conds.equal("del_flag", Constants.DEL_FLAG_0);
conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(oilRecord.getNumber())) {
    conds.like("number", oilRecord.getNumber());
    }
        if (!StringUtils.isEmpty(oilRecord.getMemberId())) {
    conds.equal("member_id", oilRecord.getMemberId());
    }
        if (!StringUtils.isEmpty(oilRecord.getType())) {
    conds.like("type", oilRecord.getType());
    }
        if (!StringUtils.isEmpty(oilRecord.getQuota())) {
    conds.like("quota", oilRecord.getQuota());
    }
    Sort sort = new Sort("create_time", OrderType.DESC);

List<OilRecord> list = oilRecordService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
Integer counts = oilRecordService.count(conds);
JSONObject rtnJson = new JSONObject();
rtnJson.put("iTotalRecords", counts);
rtnJson.put("iTotalDisplayRecords", counts);
rtnJson.put("aaData", list);
return rtnJson;
}

//删除数据
@RequiresPermissions(value = OILRECORD_EDIT)
@RequestMapping("/delete")
@ResponseBody
public JSONObject delete(String id) {
JSONObject rtnJosn = new JSONObject();
try {
oilRecordService.delete(id);
rtnJosn.put("errorNo", 0);
} catch (Exception e) {
rtnJosn.put("errorNo", 1);
}
return rtnJosn;
}

}
