package com.cftech.review.web;


import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.JsonDateValueProcessor;
import com.cftech.core.util.MpTokenUtil;
import com.cftech.core.util.StringUtils;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import com.cftech.review.model.Review;
import com.cftech.review.service.ReviewService;
import com.cftech.review.vo.ReviewDto;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.wxbase.wxmedia.JwMediaAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by lisw on 2017/5/11 0011.
 * 评论相关接口
 */
@RestController
@RequestMapping("/mobile/auth/review")
public class MobileReviewController {

    @Autowired
    private ReviewService reviewService;

    @Autowired
    private MpTokenUtil mpTokenUtil;

    /**
     * 我的评价
     */
    @RequestMapping(value = {"/list", ""}, method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String getMyCommentList(HttpServletRequest request, Long memberid,
                                   int page, int pageSize, Long accountsId) {
        JSONObject result = new JSONObject();
        // 条件
        page=page*pageSize;
        Conds conds = new Conds();
        conds.equal("t.create_by", memberid);
        conds.equal("t.del_flag", "0");
        conds.equal("t.accounts_id", accountsId);
        // 排序
        Sort sort = new Sort("create_time", OrderType.DESC);
        // 从session中获取到当前的用户id
        if (null != memberid) {
            // 获取评价
            List<Review> list = reviewService.fetchSearchByPage(conds, sort, page, pageSize);
            JsonConfig jsonConfig = new JsonConfig();
            jsonConfig.registerJsonValueProcessor(java.util.Date.class,
                    new JsonDateValueProcessor("yyyy-MM-dd HH:mm"));
            JSONArray arr = JSONArray.fromObject(list, jsonConfig);
            result.put("errorNo", "0");
            result.put("data", arr);
            return result.toString();
        }
        // 参数错误
        result.put("errorNo", "1");
        return result.toString();
    }


    /**
     * 评论
     */
    @RequestMapping(value = "/addComment", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject addComment(Review review, HttpServletRequest request,
                                 String[] imagesArray) {
        if(review.getParent_reviewid()==null){
            review.setParent_reviewid(0L);
        }

        JSONObject rtnJson = new JSONObject();
        try {
            String images = "";
//            if (imagesArray != null && imagesArray.length > 0) {
//                for (String arr : imagesArray) {
//                    try{
//                        Cosconfig cosconfig = new Cosconfig();
//                        /**
//                         * 按照需要上传逻辑，做上传的相关配置
//                         */
//                      JSONObject mediaJson= JwMediaAPI.downMedia(mpTokenUtil.getToken(review.getAccountsId()),arr,"",cosconfig);
//                        images += mediaJson.getString("fileName") + ";";
//                    } catch (WexinReqException e) {
//                        // TODO Auto-generated catch block
//                        e.printStackTrace();
//                    }
//                }
//        }
//        if (StringUtils.isNotBlank(images)) {
//               review.setImages(images);
//            }
            review.setFabulous(Long.valueOf(0));
            review.setLikes("1");
            review.setStatus("1");
            reviewService.save(review);
            reviewService.updateexhibi(review);
            rtnJson.put("errorNo", 0);
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }



    /**
     * 查询某模块某实体下的评论
     */
    @RequestMapping(value = "/moduleReviewListByFans",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject moduleReviewListByFans(Long accountsId,String moduleType,Long entityId,int page,int pageSize,String openId){
        page=page*pageSize;
        JSONObject rtnJson = new JSONObject();
        Conds conds = new Conds();
        conds.equal("review.module_type", moduleType);
        conds.equal("review.entity_id", entityId);
        conds.equal("review.del_flag",0);
        conds.equal("review.accounts_id", accountsId);
        conds.equal("fans.delflag","0");
        // 排序
        Sort sort = new Sort("review.create_time", OrderType.DESC);
        // 从session中获取到当前的用户id
        if (null != entityId) {
            // 获取评价
            //如果list里面一条数据中的islike字段不为空  则该人已经点赞该评论
            List<ReviewDto> list = reviewService.fetchSearchByCondsJoinMember(conds, sort, page, pageSize,openId);

            JsonConfig jsonConfig = new JsonConfig();
            jsonConfig.registerJsonValueProcessor(java.util.Date.class,
                    new JsonDateValueProcessor("yyyy-MM-dd HH:mm"));
            JSONArray arr = JSONArray.fromObject(list, jsonConfig);
            rtnJson.put("errorNo", "0");
            rtnJson.put("data", arr);
            return rtnJson;
        }
        // 参数错误
        rtnJson.put("errorNo", "1");
        return rtnJson;
    }

}
