var activityAgenda = (function () {
  'use strict';
  var ActivityAgenda = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/agenda/getagenda',
      postApi: G.baseUri() + '/mobile/auth/agenda/inseragendasroe',
      clickspeech: G.baseUri() + '/mobile/auth/speech/getspeechdetails',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/activity-agenda.json';
      p.params.postApi = 'json/code.json';
      p.params.clickspeech = 'json/guest-information.json';

    }
    p.page = 0;
    p.loading = false;

    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);
    Handlebars.registerHelper({
      'datetimeformat': function (t) {
        var date = new Date(t);
        return dataUtils.dateFormat(date, 'yyyy-MM-dd')
      },
      'scoreHtml': function (s) {

        if (s == 1) {
          var html = '<img src="image/star-green.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '</div>' +
            '<p class="color-green">1.0</p>';

        } else if (s == 2) {
          var html = '<div class="stars align-center">' + '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '</div>' +
            '<p class="color-green">2.0</p>';

        } else if (s == 3) {
          var html = '<div class="stars align-center">' + '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '</div>' +
            '<p class="color-green">3.0</p>';

        } else if (s == 4) {
          var html = '<div class="stars align-center">' + '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '</div>' +
            '<p class="color-green">4.0</p>';

        } else if (s == 5) {
          var html = '<div class="stars align-center">' + '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '<img src="image/star-green.png" alt="">' +
            '</div>' +
            '<p class="color-green">5.0</p>';

        } else if (!s || s == '') {
          var html = '<div class="stars align-center">' + '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '<img src="image/star.png" alt="">' +
            '</div>' +
            '<p class="color-green">0.0</p>';
        }
        return html
      },
      'isScore': function (s) {
        if (!s || s == '') {
          return 'noscored';
        }

      }
    });
    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {
        var sideDiv = new side({
          currentIndex: '0',
          cfApp: cfApp
        });
        sideDiv.init();
        var text = null;
        var str1 = null;
        var str2 = null;
        if(p.english){
          text =  '<span style="color:#000">Please submit your schedule.</span>';
          str1 = "Not now";
          str2 = "Go";
        }else{
          text =  '<span style="color:#000">请及时提交个人行程！</span>';
          str1 = "暂不";
          str2 = "前往";
        }
        var modal = cfApp.getQueryString('modal');
        if (modal == 1) {
          $.modal({
            title: "",
            text: text,
            buttons: [{
                text: str1,
                //className: "leftBtn"
                onClick:function(){
                  if(p.english){
                    location.href = 'agenda-special-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
                  }else{
                    location.href = 'agenda-special.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
                  }
                }
              },
              {
                text: str2,
                onClick: function () {
                  if (p.english) {
                    location.href = 'my-schedule-form-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
                  } else {
                    location.href = 'my-schedule-form.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
                  }

                }
              }
            ]
          });
        }else if(modal==0){
          $.modal({
            title: "",
            text: text,
            buttons: [{
              text: str1,
              //className: "leftBtn"
              onClick:function(){
                if(p.english){
                  location.href = 'activity-agenda-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
                }else{
                  location.href = 'activity-agenda.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
                }
              }
            },
              {
                text: str2,
                onClick: function () {
                  if (p.english) {
                    location.href = 'my-schedule-form-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
                  } else {
                    location.href = 'my-schedule-form.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
                  }

                }
              }
            ]
          });
        }
        log();
        loadData();
        initInfinite();
        StarEvent();
        submit();

        $('.language').click(function () {
          if (!p.english) {
            location.href = 'activity-agenda-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
          } else {
            location.href = 'activity-agenda.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
          }

        });
        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "研讨会",
        modulename: "活动议程",
        keyword: "活动议程",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {
      $.showLoading();
      var formdata = {
        meetingId: cfApp.getQueryString('id'),
        page: p.page,
        pagesize: 10,
        member_uid: p.empInfo.memberId
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        if (retdata.errorNo == '0') {
          if (p.english) {
            $('#title').text(retdata.workshop_title_en);
          } else {
            $('#title').text(retdata.workshop_title);
          }



          for (var i = 0, j = retdata.agenda.length; i < j; i++) {

            if(retdata.agenda[i].agenda_title.indexOf("amp;")!=-1){
                retdata.agenda[i].agenda_title = retdata.agenda[i].agenda_title.replace("amp;","");
            }

              if(retdata.agenda[i].agenda_title_en.indexOf("amp;")!=-1){
                  retdata.agenda[i].agenda_title_en = retdata.agenda[i].agenda_title_en.replace("amp;","");
              }

            if(retdata.agenda[i].speech_name && retdata.agenda[i].speech_name!=null){
                retdata.agenda[i].isSpeech=true;
            }else{
                retdata.agenda[i].isSpeech=false;
            }
            for (var m = 0, n = retdata.data.length; m < n; m++) {
              if (retdata.agenda[i].id == retdata.data[m].id) {
                retdata.agenda[i].score = retdata.data[m].score
              }
            }
          }

          console.log(retdata)
          var content = $('#list-template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata);
          $('#list').append(htmlStr);
          if (retdata.agenda.length < 10) {
            $('.weui-loadmore').remove();
            p.loading = true;
          } else {
            p.page++;
            p.loading = false;
          }

        }

      });


    }



    var initInfinite = function () {
      $('body').infinite().on("infinite", function () {
        if (p.loading) return;
        p.loading = true;

        setTimeout(function () {

          loadData();

        }, 800);
      });
    };


    var StarEvent = function () {

      $('body').on('click', '.stars img', function () {
        var obj = $(this);
        var index = obj.index();
        console.log(index);
        obj.attr('src', 'image/star-green.png');
        obj.prevAll('img').attr('src', 'image/star-green.png');
        obj.nextAll('img').attr('src', 'image/star.png');
        obj.parents('.stars').next('p').text((index + 1) + '.0');
        obj.parents('li').attr('data-score', (index + 1));
        obj.parents('li').removeClass('noscored');

        obj.parents('li').addClass('changed');



      });
    }

      $('#list').on('click', 'li span', function () {
          var obj = this;

          if(p.english){
              location.href = 'guest-information-english.html?appid=' + p.params.appid+'&id='+cfApp.getQueryString('id')+'&speechId='+$(obj).attr("data-speech")+"&english=1";
          }else{
              location.href = 'guest-information.html?appid=' + p.params.appid+'&id='+cfApp.getQueryString('id')+'&speechId='+$(obj).attr("data-speech");
          }
      })

    var submit = function () {

      $('#submit').click(function () {


        if ($('.noscored').length > 0) {
          $.modal({
            title: "",
            text: '<span class="color-green">有未打分的议程！</span><br>Please input the<br>phone number',
            buttons: [{
              text: "确定OK"
            }]
          });

          return false;
        }
        var agendascore = {

          accountsid: p.empInfo.accountsId,
          member_uid: p.empInfo.memberId,
          scroe: ""
        }
        var scoreArr = [];
        $('#list li.changed').each(function () {
          var obj = new Object;
          var scroe = $(this).attr('data-score');
          var id = $(this).attr('id');
          obj.agenda_id = id;
          obj.scroe = scroe;
          scoreArr.push(obj);

        });
if(scoreArr.length==$('.changed').length){
  agendascore.scroe = JSON.stringify(scoreArr);
  agendascore=JSON.stringify(agendascore);

  var formdata={
    agendascore:agendascore
  }


  G.ajax(G.devModePost, p.params.postApi, formdata, function (retdata) {
    if (retdata.errorNo == '0') {
      $.modal({
        title: "",
        text: '<span class="color-green">提交成功！</span><br>Success',
        buttons: [{
          text: "确定OK"
        }]
      });
    }
  })
}
        


        console.log(agendascore);
      })

    }




  };

  return ActivityAgenda;
})();
