package com.cftech.workshop.demand.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.util.DateUtils;
import com.cftech.workshop.demand.model.Demand;
import com.cftech.workshop.demand.service.DemandService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.service.MeetingService;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String DEMAND_VIEW = "qy:demand:view"
 * 查看:public static final String DEMAND_EDIT = "qy:demand:edit"
 *
 * @author byj
 * @date: 2018-07-03 17:56
 */
@Slf4j
@Controller
@RequestMapping("/a/demand")
public class DemandController {

    public static final String DEMAND_VIEW = "qy:demand:view";
    public static final String DEMAND_EDIT = "qy:demand:edit";

    @Autowired
    private DemandService demandService;
    @Autowired
    private CodingruleUtils codingruleUtils;
    @Autowired
    private MeetingService meetingService;


    //列表页面
    @RequiresPermissions(value = DEMAND_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model ,Long meetingId) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId", meetingId);
        return "demand/demandlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = DEMAND_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model , Long meetingId) {
        Meeting meeting = meetingService.fetchById(meetingId);
        if(meeting!=null){
            if(!StringUtils.isEmpty(meeting.getService())){
                model.addAttribute("service", HtmlUtils.htmlUnescape(meeting.getService()));
                model.addAttribute("star",DateUtils.formatDate(meeting.getStartTime()));
                model.addAttribute("end",DateUtils.formatDate(meeting.getEndTime()));
            }else{
                model.addAttribute("service", 0);
            }
            if(!StringUtils.isEmpty(meeting.getClosing_date())){
                model.addAttribute("closing_date", DateUtils.formatDate(meeting.getClosing_date()));
            }

        }
        model.addAttribute("meetingId", meetingId);
        return "demand/demandform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = DEMAND_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Demand demand, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (demand != null && demand.getId() != null) {
                demand.setUpdateBy(UserUtils.getUser().getId());
                demandService.update(demand);
                rtnJson.put("errorNo", 0);
            } else {
                demand.setNumber(codingruleUtils.getNumber(accountsId, Demand.class.getName()));
                demand.setAccountsId(accountsId);
                demand.setDelFlag(false);
                demand.setAccountsId(UserUtils.getmpaccounts(request));
                demand.setCreateBy(UserUtils.getUser().getId());
                demand.setUpdateBy(UserUtils.getUser().getId());
                demandService.save(demand);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = DEMAND_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Demand demand, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(demand.getNumber())) {
            conds.like("number", demand.getNumber());
        }
        if (!StringUtils.isEmpty(demand.getActiv_id())) {
            conds.equal("activ_id", demand.getActiv_id());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Demand> list = demandService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = demandService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = DEMAND_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            demandService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
