package com.cftech.base.appmenu.model;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * t_appmenu 实体类
 * 应用菜单表
 * Created by Neil 28/02/2017.
 */
@Data
public class Appmenu implements Serializable {
    /**
     * 组织id
     */
    private Long id;

    /**
     * 应用菜单名称
     */
    private String name;

    /**
     * 所属的账号
     */
    private Long accountsId;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建时间
     */
    private Timestamp createTime;

    /**
     * updateTime
     */
    private Timestamp updateTime;

    /**
     * description
     */
    private String description;

    /**
     * delFlag
     */
    private boolean delFlag;

    /**
     * createBy
     */
    private Long createBy;

    /**
     * updateBy
     */
    private Long updateBy;

    /**
     * 菜单图标
     */
    private String icon;

    /**
     * 图标颜色
     */
    private String color;

    /**
     * 编码
     */
    private String number;

    /**
     * 排序数字越小排在越上
     */
    private Integer sortno;

    /**
     * 可访问的职位列表
     */
    private String positionIds;

    /**
     * 可访问的职位名称列表
     */
    private String positionNames;

    /**
     * 微信应用的Id
     */
    private Integer app;

    /**
     * 链接地址
     */
    private String link;


    public Appmenu() {
        this.status = "0";
        this.delFlag = false;
    }
}