package com.cftech.questionnaire.core.questions.model;

import lombok.Data;
import org.springframework.data.annotation.Transient;

import java.io.Serializable;
import java.util.Date;

/**
 * 问卷题库
 *
 * @author wxf
 * @date: 2017-05-24 11:43
 */
@Data
public class Questions implements Serializable {

    /* 主键id */
    private Long id;
    /* 题目类型 */
    private QuestionsType questionType;

    /* 题目类型 */
    private Long questionsCategory;

    /* 题目类型名称 */
    @Transient
    private String questionsCategoryName;

    /* 题目名称 */
    private String questionTitle;

    private String questionTitleEn;
    /**
     * 题目内容
     * {
     *     title: 题目标题
     *     type: 题目类型
     *     max:选项限制
     *     options: [    选项组合
     *      {
     *          label: '标签名称 ABC 123'
     *          name: '选项名称',
     *          pic: '选项图片链接'
     *      }
     *     ]
     * }
     */
    private String optiondetails;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Questions() {
        this.delFlag = false;
        this.status = "0";
    }

}