package com.cftech.cms.SendEmail;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.exhibi_material.model.Exhibi_material;
import com.cftech.core.util.FileUtils;
import com.cftech.core.util.QcloudUploadUtils;
import com.cftech.core.util.SystemConfig;
import com.qcloud.cos.request.UploadFileRequest;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;



public class ZipUtils {
    private static final int  BUFFER_SIZE = 2 * 1024;
    public static File toZip(List<Exhibi_material> srcFiles)throws RuntimeException {
        long start = System.currentTimeMillis();
        // 压缩文件中的文件名可能会粗线乱码，设置一下编码方式
        ZipOutputStream zos = null;
        File zip = null;
        String file_path = null;
        try {
            zip = File.createTempFile("TheZip"+System.currentTimeMillis(), ".zip");
            // 是org.apache.tools.zip.ZipOutputStream
            zos = new ZipOutputStream(new FileOutputStream(zip));
            //zos = new ZipOutputStream(out);
            for (Exhibi_material srcFile : srcFiles) {
                byte[] buf = new byte[BUFFER_SIZE];
                zos.putNextEntry(new ZipEntry(System.currentTimeMillis()+srcFile.getMaterial_name()));
                int len;
                InputStream in = FileUtils.getInputStream(srcFile.getFile_path());
                while ((len = in.read(buf)) != -1){
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            long end = System.currentTimeMillis();
//            UploadFileRequest uploadFileRequest = new UploadFileRequest(SystemConfig.p.getProperty("Qcloud_BUCKET_NAME"), "/gogi/newReCommend/附件"+end+".zip", "");
//            FileInputStream fis = new FileInputStream(zip);
//            byte[] receData =getBytes(zip);
//            ByteArrayInputStream array = new ByteArrayInputStream(receData);
//            String content  = new String(receData, "ISO-8859-1");
//            String res = QcloudUploadUtils.uploadStream(uploadFileRequest, array,content);
//            JSONObject jsonObject = JSONObject.parseObject(res);
//            String data =jsonObject.getString("data");
//            JSONObject jsonObject1 = JSONObject.parseObject(data);
//            file_path = jsonObject1.getString("access_url");
//            System.out.println("压缩完成，耗时：" + (end - start) +" ms");
        } catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils",e);
        }finally{
            if(zos != null){
                try {
                    zos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return zip;
    }


    private static byte[] getBytes(File file){
        byte[] buffer = null;
        try {

            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            int n;
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }
}
