package com.cftech.consultsheet.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.consultsheet.model.ConsultSheet;
import com.cftech.consultsheet.model.ConsultSheetDto;
import com.cftech.consultsheet.service.ConsultSheetService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * Created by 16444 on 2020/10/15.
 */
@RestController
@RequestMapping("/mobile/auth/consultSheet")
public class MobileConsultSheetController {

    @Autowired
    private ConsultSheetService consultSheetService;

    /**
     * 提交咨询单接口
     * @return
     */
    @RequestMapping(value = "/submitConsultSheet",
            method = {RequestMethod.GET, RequestMethod.POST},
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject submitConsultSheet(ConsultSheet consultSheet) {
        return consultSheetService.pollingConsultSheet(consultSheet);
    }
    /**
     * @Author Licc
     * @Description  咨询单列表 搜索
     * @Date 13:01 2020/11/1
     * @Param  
     * @return 
     **/
    @RequestMapping(value = "/consultSheetList",
            method = {RequestMethod.GET, RequestMethod.POST},
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject consultSheetList(ConsultSheetDto consultSheetDto) {
        return consultSheetService.consultSheetList(consultSheetDto);
    }

    @RequestMapping(value = "/test",
            method = {RequestMethod.POST},
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public void test(Long id) {
        ConsultSheet consultSheet = consultSheetService.fetchById(id);
        consultSheetService.sendQyWechatMassage(consultSheet);

    }
}
