package com.cftech.consultsheet.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.cftech.core.poi.ExportConfig;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import org.codehaus.jackson.format.DataFormatMatcher;

import java.io.Serializable;
import java.util.Date;

/**
 * 咨询单
 *
 * @author Licc
 * @date: 2020-09-22 12:06
 */
@Data
public class ConsultSheet extends UserSheet implements Serializable {


    /* 主键id */
    private Long id;
    /* 咨询单编码 */
    @ExportConfig(value = "咨询单编码", width = 100, showLevel = 1)
    private String consultId;
    /* 用药人name */
    @ExportConfig(value = "用药人姓名", width = 100, showLevel = 1)
    private String userName;
    /* 身份证号 */
    private String numberId;
    /* 性别 */
    @ExportConfig(value = "性别", width = 100, showLevel = 1)
    private Long sex;
    /* 手机号 */
    @ExportConfig(value = "联系电话", width = 100, showLevel = 1)
    private String phone;
    /* 有无不良反应 */
    @ExportConfig(value = "有无不良反应", width = 100, showLevel = 1)
    private Long pastRecords;
    /* 有无过敏反应 */
    @ExportConfig(value = "有无过敏反应", width = 100, showLevel = 1)
    private Long allergy;
    /* 是否服用过该药且无禁忌症 */
    @ExportConfig(value = "是否服用过该药且无禁忌症", width = 100, showLevel = 1)
    private Long illness;
    /* 处方单 */
    @ExportConfig(value = "处方单", width = 100, showLevel = 1)
    private String prescription;
    /* 药师id */
    private Long doctorId;
    /* 客服id */
    private Long serviceId;
    /* 线下已确证疾病 */
    private String symptom;
    /*是否已在医院确诊*/
    private Long diagnosis;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    @ExportConfig(value = "是否审核", width = 100, showLevel = 1)
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 是否勾选处方单真实性声明 0:未勾选 1:勾选 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    /* 粉丝id */
    private String openId;
    /* 药品id */
    private Long drugsId;
    /* 会员id */
    private Long memberId;
    /* 订单id */
    private Long orderId;

    private String appId;
    public ConsultSheet() {
        this.delFlag = false;
        this.status = "0";
    }

}