package com.cftech.activity.log.service.impl;

import com.cftech.activity.log.dao.WheelLogMapper;
import com.cftech.activity.log.model.WheelLog;
import com.cftech.activity.log.model.WheelLogDto;
import com.cftech.activity.log.service.WheelLogService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 大转盘活动记录表ServiceImpl
 *
 * @author lisw
 * @date: 2017-04-27 13:57
 */
@Service("wheelLogService")
public class WheelLogServiceImpl extends GenericServiceImpl<WheelLog> implements WheelLogService {

    @Autowired
    @Qualifier("wheelLogMapper")
    private WheelLogMapper wheelLogMapper;

    @Override
    public GenericDao<WheelLog> getGenericMapper() {
        return wheelLogMapper;
    }

    @Override
    public List<WheelLogDto> fetchSearchByPageDto(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return wheelLogMapper.fetchSearchByPageDto(params);
    }

}