package com.cftech.cms.cfarticle.dao;

import com.cftech.cms.cfarticle.model.Cfarticle;
import com.cftech.cms.cfarticle.model.CfarticleColumnDto;
import com.cftech.core.generic.GenericDao;

import java.util.List;
import java.util.Map;

/**
* CMS文章管理Mapper
*
* @author lisw
* @date: 2017-05-03 10:51
*/
public interface CfarticleMapper extends GenericDao<Cfarticle> {

    /**
     * 分页查询
     *
     * @param params
     * @return
     */
    List<CfarticleColumnDto> fetchSearchByPageTemp(Map<String, Object> params);

    /**
     * 查询总数
     *
     * @return
     */
    int countTemp(Map<String, Object> params);

    /**
     * 根据Id in查询，并根据IN的顺序排序查询
     */
    List<Cfarticle> fetchSearchByPageInOrder(Map<String,Object> params);

    int countReview(Map<String,Object> params);
}