package com.cftech.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;

import com.cftech.core.schafflerentity.VisitEntity;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.security.access.method.P;

public class SchafflerExcel {
	public static void main(String[] args) throws IOException {
		Date meetingStart = DateUtils.parseDate("2018-07-11");
		Date meetingEnd = DateUtils.parseDate("2018-07-15");
        List<String> strList = new ArrayList<String>();
        strList.add(DateUtils.formatDate(meetingStart,"yyyy-MM-dd"));
		for(int i =1;i>=1;i++){
			Calendar c = Calendar.getInstance();
			c.setTime(meetingStart);
			c.add(Calendar.DAY_OF_MONTH, i);// 今天+1天
			Date tomorrow = c.getTime();
            strList.add(DateUtils.formatDate(tomorrow,"yyyy-MM-dd"));
            if(DateUtils.isSameDay(tomorrow,meetingEnd)){
                break;
            }
		}
		List<String> gongchangList = new ArrayList<String>();
        gongchangList.add("2018-07-02");
        gongchangList.add("2018-07-06");
        List<String> shicheng = new ArrayList<String>();
        gongchangList.add("2018-07-01");
        gongchangList.add("2018-07-04");


        List<VisitEntity> list = new ArrayList<VisitEntity>();
        list=mockData();


		SchafflerExcel schaffler = new SchafflerExcel();
        schaffler.generateExcel(strList,gongchangList,shicheng,list);
	}

	private  void generateExcel(List<String> dynamicCols,List<String> plantCols,List<String> testDriveCols,List<VisitEntity> mockDataList) throws IOException
	{
		int dySize = dynamicCols.size();
		int plantSize = plantCols.size();
		int testDriveSize = testDriveCols.size();
		//创建Excel
		HSSFWorkbook  wb = new HSSFWorkbook();
		//创建sheet
		Sheet createSheet = wb.createSheet("Engine");
		// 设置标题字体
		Font fontTitle = wb.createFont();
		fontTitle.setFontHeightInPoints((short) 10); // 字体大小
		fontTitle.setColor(HSSFColor.WHITE.index); // 字体颜色
		fontTitle.setFontName("Arial"); // 字体
		//fontTitle.setBoldweight(Font.BOLDWEIGHT_BOLD); // 粗体显示
		fontTitle.setBold(true);
		// 设置标题单元格类型  //蓝色区域
		CellStyle greenRegion = generateHeaderStyle(IndexedColors.GREEN.index,wb,fontTitle,(byte) 0, (byte) 137, (byte) 61);
		CellStyle blueRegion = generateHeaderStyle(IndexedColors.BLUE.index,wb,fontTitle,(byte) 0, (byte) 176, (byte) 240);
		CellStyle darkRegion =  generateHeaderStyle(IndexedColors.DARK_BLUE.index,wb,fontTitle,(byte) 31, (byte) 73, (byte) 125);
		CellStyle greyRegion =  generateHeaderStyle(IndexedColors.GREY_25_PERCENT.index,wb,fontTitle,(byte) 217, (byte) 217, (byte) 217);


		CellStyle cellStyle = highlightedCell(wb);

		// 创建合并单元格
		Map<String,CellRangeAddress> regions = initRange(dySize,plantSize,testDriveSize);
		//合并单元格
		addRange(createSheet, regions);
		// -----------填充第一行数据-------------
		Row rowTitle = createSheet.createRow(0);
		generateCell(rowTitle,0,greenRegion,"Item No.");
		generateCell(rowTitle,1,blueRegion,"个人信息 \n Personal Information");
		generateCell(rowTitle,8+3,greenRegion,"Hospitality Information \n 入住信息");
		generateCell(rowTitle,10+3+dySize,darkRegion,"Transporatation \n 交通");
		generateCell(rowTitle,19+3+dySize,greenRegion,"Plant Tour \n 工厂参观");
		generateCell(rowTitle,19+3+plantSize+dySize,greenRegion,"Test Drive \n 试乘试驾");
		generateCell(rowTitle,19+3+plantSize+dySize+testDriveSize,greenRegion,"Remark \n 备注");
		rowTitle.setHeightInPoints(80);
		// -----------填充第二行数据-------------
		Row seoncRow = createSheet.createRow(1);
		generateCell(seoncRow,8+3,greenRegion,"需要住宿");//living
		generateCell(seoncRow,8+3+dySize,greenRegion,"不需要住宿");//no living
		generateCell(seoncRow,9+3+dySize,greenRegion,"Non-smoking Room \n 无烟房"); //noSmoking
		generateCell(seoncRow,10+3+dySize,darkRegion,"Pick-up Service \n 接机/接站");//pickUp
		generateCell(seoncRow,14+3+dySize,darkRegion,"Drop-off Service \n 送机/送站");//dropOff
		generateCell(seoncRow,18+3+dySize,darkRegion,"Self-driving \n 自驾");//selfDriving
		//设置动态列内容
		for(int i=0;i<plantSize;i++)
		{
			String value = plantCols.get(i);
			generateCell(seoncRow,i+19+3+dySize,greenRegion,value);
		}
		for(int i=0;i<testDriveSize;i++)
		{
			String value = testDriveCols.get(i);
			generateCell(seoncRow,19+3+plantSize+dySize+i,greenRegion,value);
		}
		// -----------填充第三行数据-------------
		Row lastHeaderRow = createSheet.createRow(2);
		generateCell(lastHeaderRow,1,blueRegion,"Last Name \n 姓");// 设置 姓
		generateCell(lastHeaderRow,2,blueRegion,"First Name \n 名");// 设置 名
		generateCell(lastHeaderRow,3,blueRegion,"Gender \n 性别");//设置性别
		generateCell(lastHeaderRow,4,blueRegion,"Company/Organization \n 公司/组织");//公司/组织
		generateCell(lastHeaderRow,5,blueRegion,"Job Title \n 职务");//职务
		generateCell(lastHeaderRow,6,blueRegion,"Email Address \n 邮箱/Bussiness card  \n 名片输入");// Email Address 名片输入
		generateCell(lastHeaderRow,7,blueRegion,"Mobile Phone \n 手机");// 手机
		generateCell(lastHeaderRow,8,blueRegion,"Register Last Name \n 注册姓");// 注册姓
		generateCell(lastHeaderRow,9,blueRegion,"Register First Name \n 注册名");// 注册名
		generateCell(lastHeaderRow,10,blueRegion,"Register Mobile Phone \n 注册手机号");// 注册手机号


		//设置动态列内容
		for(int i=0;i<dynamicCols.size();i++)
		{
			String value = dynamicCols.get(i);
			generateCell(lastHeaderRow,i+3+8,greenRegion,value);// 手机
		}
		//设置最后两行为空
		for(int i=0;i<2;i++)
		{
			generateCell(lastHeaderRow,i+3+8+dySize,greenRegion,"");// 手机
		}
		generateCell(lastHeaderRow,10+3+dySize,darkRegion,"Flight No/Train No \n 航班号/车次");// 接机的航班号
		generateCell(lastHeaderRow,11+3+dySize,darkRegion,"Date of Arrival \n 到达日期");// 接机的 到达日期
		generateCell(lastHeaderRow,12+3+dySize,darkRegion,"TIme of Arrival \n 到达时间");// 接机的 到达时间
		generateCell(lastHeaderRow,13+3+dySize,darkRegion,"Arrival Airport/Train Station \n 到达站点");// 接机的 站点
		generateCell(lastHeaderRow,14+3+dySize,darkRegion,"Flight No/Train No \n 航班号/车次");// 出发的航班号
		generateCell(lastHeaderRow,15+3+dySize,darkRegion,"Departure Date \n 出发日期");// 出发日期
		generateCell(lastHeaderRow,16+3+dySize,darkRegion,"TIme of Depature \n 出发时间");// 出发时间
		generateCell(lastHeaderRow,17+3+dySize,darkRegion,"Departure Airport/Train Station \n 出发站点");// 出发站点
		//设置动态列表头最后一行的空格，否则单元格没有边框
		for(int i=0;i<plantSize;i++)
		{
			generateCell(lastHeaderRow,i+3+19+dySize,greenRegion,"");
		}
		for(int i=0;i<testDriveSize;i++)
		{
			generateCell(lastHeaderRow,19+3+plantSize+dySize+i,greenRegion,"");
		}

		generateCell(lastHeaderRow,19+3+testDriveSize+plantSize+dySize,greyRegion,"灰色提示文字：如随行人员餐饮招待、停车位等需求。");
		//设置为空单元格
		//-----结束表头设置-------
		//解决合并单元格造成的边框样式丢失问题
		handleMergeRegionCss(createSheet,regions,greenRegion,blueRegion,darkRegion);
		createSheet.setColumnWidth(0, 1200);
//		createSheet.autoSizeColumn(0, true);


		generateData(createSheet,mockDataList,dynamicCols,plantCols,testDriveCols,cellStyle);
		File ff = new File("e://testtexcel.xls");
		FileOutputStream fos = new FileOutputStream(ff);
		wb.write(fos);
		fos.close();
	}


	//生成单元格
	private void generateCell(Row row,int cellNumber,CellStyle css,String value)
	{
		Cell cellTitle = row.createCell(cellNumber);
		if(css!=null)
		cellTitle.setCellStyle(css);
		cellTitle.setCellValue(value);// 设置内容
	}


	private void setRegionStyle(Sheet sheet, CellRangeAddress region,
			CellStyle cs) {
        for (int i = region.getFirstRow(); i <= region.getLastRow(); i++) {

        	Row row = sheet.getRow(i);
            if (row == null)
                row = sheet.createRow(i);
            for (int j = region.getFirstColumn(); j <= region.getLastColumn(); j++) {
            	Cell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                    cell.setCellValue("");
                }
                cell.setCellStyle(cs);

            }
        }
    }

	//初始化region合并内容
	private  Map<String,CellRangeAddress> initRange(int dySize,int plantTourSize,int testDriveSize)
	{
		Map<String,CellRangeAddress> rangeMap = new HashMap<String,CellRangeAddress>();
		CellRangeAddress personInfo = new CellRangeAddress(0, 1,1, 7+3);// 下标从0开始 个人信息合并不包括个人信息详情合并
		CellRangeAddress itemNo = new CellRangeAddress(0, 2, 0, 0);// 起始行号，终止行号， 起始列号，终止列号   ITEMNO 合并
		CellRangeAddress liveRegion = new CellRangeAddress(0, 0,8+3, 9+dySize+3);
		CellRangeAddress needLiveRegion = new CellRangeAddress(1,1,8+3, 7+dySize+3);
		CellRangeAddress transportHeaderRegion = new CellRangeAddress(0,0,10+dySize+3, 18+dySize+3);
		CellRangeAddress pickUpRegion = new CellRangeAddress(1,1,10+dySize+3, 13+dySize+3);
		CellRangeAddress dropOffRegion = new CellRangeAddress(1,1,14+dySize+3, 17+dySize+3);
		CellRangeAddress selfDrivingRegion = new CellRangeAddress(1,2,18+dySize+3, 18+dySize+3);
		CellRangeAddress plantTourRegion = new CellRangeAddress(0,0,19+dySize+3, 18+plantTourSize+dySize+3);
		CellRangeAddress testDriveRegion = new CellRangeAddress(0,0,19+plantTourSize+dySize+3, 18+testDriveSize+plantTourSize+dySize+3);
		CellRangeAddress remarkRegion = new CellRangeAddress(0,1,19+testDriveSize+plantTourSize+dySize+3,19+testDriveSize+plantTourSize+dySize+3);
		rangeMap.put("personInfo",personInfo);
		rangeMap.put("itemNo",itemNo);
		rangeMap.put("liveRegion",liveRegion);
		rangeMap.put("needLiveRegion",needLiveRegion);
		rangeMap.put("transportHeaderRegion",transportHeaderRegion);
		rangeMap.put("pickUpRegion",pickUpRegion);
		rangeMap.put("dropOffRegion",dropOffRegion);
		rangeMap.put("selfDrivingRegion",selfDrivingRegion);
		rangeMap.put("plantTourRegion",plantTourRegion);
		rangeMap.put("testDriveRegion",testDriveRegion);
		rangeMap.put("remarkRegion",remarkRegion);
		return rangeMap;
	}


	//跟进合并单元列表 向表格中加入合并单元
	private void addRange(Sheet createSheet,Map<String,CellRangeAddress> regions)
	{
		Iterator<CellRangeAddress> coll =	regions.values().iterator();
		while(coll.hasNext())
		{
			createSheet.addMergedRegion(coll.next());
		}
	}

	//解决单元格合并问题 无边框问题。
	private void handleMergeRegionCss(Sheet createSheet,Map<String,CellRangeAddress> regions,
			CellStyle greenRegion,CellStyle	blueRegion,CellStyle darkRegion)
	{
		 for (Map.Entry<String, CellRangeAddress> entry : regions.entrySet()) {
			 String key = entry.getKey();
			 CellRangeAddress region = entry.getValue();
			 if("personInfo".equals(key))
			 {
					setRegionStyle(createSheet,region,blueRegion);
			 }else if("itemNo".equals(key)||"liveRegion".equals(key)||"needLiveRegion".equals(key)||"plantTourRegion".equals(key)||"testDriveRegion".equals(key)||"remarkRegion".equals(key))
			 {
					setRegionStyle(createSheet,region,greenRegion);
			 }else
			 {
					setRegionStyle(createSheet,region,darkRegion);
			 }
		 }
	}

	//生成标题颜色区域
	private  CellStyle generateHeaderStyle(short index,HSSFWorkbook wb,Font fontTitle,byte r,byte g,byte b)
	{
	    HSSFPalette palette = wb.getCustomPalette();
		CellStyle cellStyleTitle = wb.createCellStyle();
		cellStyleTitle.setFont(fontTitle);
		cellStyleTitle.setFillForegroundColor(index);
	    palette.setColorAtIndex(index, r, g, b); //蓝色区域
		cellStyleTitle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
		cellStyleTitle.setAlignment(HorizontalAlignment.CENTER); // 水平布局：居中
		cellStyleTitle.setVerticalAlignment(VerticalAlignment.CENTER);
		cellStyleTitle.setWrapText(true);// 设置自动换行
		cellStyleTitle.setBorderBottom(BorderStyle.THIN); // 下边框
		cellStyleTitle.setBorderLeft(BorderStyle.THIN);// 左边框
		cellStyleTitle.setBorderTop(BorderStyle.THIN);// 上边框
		cellStyleTitle.setBorderRight(BorderStyle.THIN);// 右边框
		cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
		cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
		cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
		cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
		return cellStyleTitle;
	}

	private static List<VisitEntity> mockData()
	{
		List<VisitEntity> entities = new ArrayList<VisitEntity>();
		for(int i=1;i<10000;i++)
		{
			VisitEntity entity = new VisitEntity();
			entity.setItemNo(""+i);
			entity.setLastName("Huang"+i);
			entity.setFirstName("KangLiang");
			entity.setGender("男");
			entity.setCompany("米昶");
			entity.setJob("开发");
			entity.setEmail("625515@qq.com");
			entity.setMobile("15900673023");
			entity.setRegiLasetName("Huang"+i);
			entity.setRegiFirstName("注册名:KangLiang");
			entity.setRegiMobile("注册手机号:15900673023");
			entity.setNoneedHosp("不需要住宿");
			entity.setNosmoking("需要抽烟");
			entity.setDepartFlightNo("出发A001");//送站
			entity.setDepartDate("出发2018-07-25");//送站日期
			entity.setDepartTime("出发6:00");//送站时间
			entity.setDepartStation("出发浦东");//送站站点
			entity.setPickUpFlightNo("到达B001");//接站班次
			entity.setArriveTime("到达18:00");//接站时间
			entity.setArriveStation("到达上海虹桥");//接站站点
			entity.setArriveDate("到达2018-06-25");//接站日期
			entity.setSelfDriving("无需要自驾");//是否自驾


			Map<String,String> value = new HashMap<String,String>();
			value.put("2018-07-11","是");
			value.put("11.22","是");
			value.put("11.23","否");
			entity.setNeedHosp(value);



			Map<String,String> plantTour = new HashMap<String,String>();
			plantTour.put("11.21","需要参观");
			plantTour.put("11.22","需要参观");
			plantTour.put("11.23","不需要参观");
			entity.setPlanTour(plantTour);

			Map<String,String> testDrives = new HashMap<String,String>();
			testDrives.put("11.21","需要自驾");
			testDrives.put("11.22","需要自驾");
			testDrives.put("11.23","不需要自驾");
			entity.setTestDrive(testDrives);

			entity.setRemark("备注"+i);
			highlightCell(entity);
			entities.add(entity);
		}
		return entities;
	}


	//判断是否需要高亮单元格
	public static void highlightCell(VisitEntity visitEntity)
	{
		List<String> i = new ArrayList<String>();
		//判断名字
		boolean lastNameFlag = false;
		boolean firstNameFlag = false;
		boolean regoMobileFlag = false;
		String lastName = visitEntity.getLastName();
		String regiLastName = visitEntity.getRegiLasetName();
		if(!lastName.equals(regiLastName))
		{
			lastNameFlag = true;
		}
		String firstName = visitEntity.getFirstName();
		String regiFirstName = visitEntity.getRegiFirstName();
		if(!firstName.equals(regiFirstName))
		{
			firstNameFlag = true;
		}
		String mobile = visitEntity.getMobile();
		String regoMobile = visitEntity.getRegiMobile();
		if(!mobile.equals(regoMobile))
		{
			regoMobileFlag = true;
		}
		// 1 8 2 9 7 10
		if(lastNameFlag)
		{
			i.add("1") ;
			i.add("8");
		}
		if(firstNameFlag)
		{
			i.add("2") ;
			i.add("9");
		}

		if(regoMobileFlag)
		{
			i.add("7") ;
			i.add("10");
		}
		visitEntity.setHightLightedCols(i);
	}

	//生成数据
	private void generateData(Sheet createSheet, List<VisitEntity> entities,List<String> dyCols,List<String> plantCols,List<String> testDriveCols,CellStyle cellStyle)
	{
		int dataSize = entities.size();
		for(int i=0;i<dataSize;i++)
		{	Row dataRow = createSheet.createRow(3+i);
			int dyColsSize = dyCols.size();
			int plantSize = plantCols.size();
			int testDriveSize = testDriveCols.size();
			VisitEntity visitEntity = entities.get(i);
			List<String> highLightedCells = visitEntity.getHightLightedCols();
			Map<String,String> value = visitEntity.getNeedHosp();
			Map<String,String> plant = visitEntity.getPlanTour();
			Map<String,String> testDrive = visitEntity.getTestDrive();
			generateCell(dataRow,0,null,visitEntity.getItemNo());
			if(highLightedCells.contains("1"))
			{
				generateCell(dataRow,1,cellStyle,visitEntity.getLastName());
			}else
			{
				generateCell(dataRow,1,null,visitEntity.getLastName());
			}
			if(highLightedCells.contains("2"))
			{
				generateCell(dataRow,2,cellStyle,visitEntity.getFirstName());
			}else
			{
				generateCell(dataRow,2,null,visitEntity.getFirstName());
			}

			generateCell(dataRow,3,null,visitEntity.getGender());
			generateCell(dataRow,4,null,visitEntity.getCompany());
			generateCell(dataRow,5,null,visitEntity.getJob());
			generateCell(dataRow,6,null,visitEntity.getEmail());

			if(highLightedCells.contains("7"))
			{
				generateCell(dataRow,7,cellStyle,visitEntity.getMobile());
			}else
			{
				generateCell(dataRow,7,null,visitEntity.getMobile());
			}



			if(highLightedCells.contains("8"))
			{
				generateCell(dataRow,8,cellStyle,visitEntity.getRegiLasetName());
			}else
			{
				generateCell(dataRow,8,null,visitEntity.getRegiLasetName());
			}


			if(highLightedCells.contains("9"))
			{
				generateCell(dataRow,9,cellStyle,visitEntity.getRegiFirstName());
			}else
			{
				generateCell(dataRow,9,null,visitEntity.getRegiFirstName());
			}


			if(highLightedCells.contains("10"))
			{
				generateCell(dataRow,10,cellStyle,visitEntity.getRegiMobile());
			}else
			{
				generateCell(dataRow,10,null,visitEntity.getRegiMobile());
			}



			//生成动态列
			for(int q=0;q<dyColsSize;q++)
			{
				String key = dyCols.get(q);
				String content = value.get(key);
				generateCell(dataRow,8+q+3,null,content);
			}

			generateCell(dataRow,8+3+dyColsSize,null,visitEntity.getNoneedHosp());
			generateCell(dataRow,9+3+dyColsSize,null,visitEntity.getNosmoking());

			generateCell(dataRow,10+3+dyColsSize,null,visitEntity.getPickUpFlightNo());//接机航班号
			generateCell(dataRow,11+3+dyColsSize,null,visitEntity.getArriveDate());//接机到达日期
			generateCell(dataRow,12+3+dyColsSize,null,visitEntity.getArriveTime());//接机到达时间
			generateCell(dataRow,13+3+dyColsSize,null,visitEntity.getArriveStation());//接机站点
			generateCell(dataRow,14+3+dyColsSize,null,visitEntity.getDepartFlightNo());//出发航班号
			generateCell(dataRow,15+3+dyColsSize,null,visitEntity.getDepartDate());//出发日期
			generateCell(dataRow,16+3+dyColsSize,null,visitEntity.getDepartTime());//出发时间
			generateCell(dataRow,17+3+dyColsSize,null,visitEntity.getDepartStation());//出发站点
			generateCell(dataRow,18+3+dyColsSize,null,visitEntity.getSelfDriving());//自驾

			//工厂参观
			for(int q=0;q<plantCols.size();q++)
			{
				String key = plantCols.get(q);
				String content = plant.get(key);
				generateCell(dataRow,19+3+dyColsSize+q,null,content);
			}
			// 试乘试驾
			for(int q=0;q<testDriveCols.size();q++)
			{
				String key = testDriveCols.get(q);
				String content = testDrive.get(key);
				generateCell(dataRow,19+3+q+plantSize+dyColsSize,null,content);
			}
			generateCell(dataRow,19+3+testDriveSize+plantSize+dyColsSize,null,visitEntity.getRemark());


		}
	}

	public HSSFCellStyle highlightedCell(HSSFWorkbook wb)
	{
		HSSFCellStyle style = wb.createCellStyle();
		style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
		style.setFillForegroundColor(HSSFColor.RED.index);
		return style;
	}

}
