package com.cftech.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.ObjectUtils;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

/**
 * KangLiang Huang
 * Created by user on 2018/7/25.
 */
public class ConvertPwdPropertyConfigurer extends PropertyPlaceholderConfigurer {

    private static final Logger logger = LoggerFactory.getLogger(ConvertPwdPropertyConfigurer.class);

    public static final Set<String> CON_PROPERTY = new HashSet<String>();
    static
    {
        CON_PROPERTY.add("jdbc.username");
        CON_PROPERTY.add("jdbc.password");
        CON_PROPERTY.add("mongo.username");
        CON_PROPERTY.add("mongo.password");
    }

    @Override
    protected String convertProperty(String propertyName,String propertyValue)
    {
       // logger.info("=========="+propertyName+":"+propertyValue+"==========");
        if(CON_PROPERTY.contains(propertyName))
        {
            try {
                return DESUtil.decrypt(propertyValue, DESUtil.KEY);
            } catch (Exception e) {
                logger.error("配置文件加载密码异常，原因解密："+propertyName+"字段失败",e);
                return propertyValue;
            }
        }else
        {
            return propertyValue;
        }
    }
}
