package com.cftech.waybill.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 顺丰物流运单
 *
 * @author Strive
 * @date: 2020-10-21 15:04
 */
@Data
public class Waybill implements Serializable {

    /* 主键id */
    private Long id;
    /* 咨询单Id */
    @ExportConfig(value = "咨询单Id", width = 100, showLevel = 1)
    private Long consultId;
    /* 订单Id */
    @ExportConfig(value = "订单Id", width = 100, showLevel = 1)
    private Long orderId;
    /* 物流单编码 */
    @ExportConfig(value = "物流单编码", width = 100, showLevel = 1)
    private String number;
    /* 会员Id */
    @ExportConfig(value = "会员Id", width = 100, showLevel = 1)
    private String memberId;
    /* 粉丝Id */
    @ExportConfig(value = "粉丝Id", width = 100, showLevel = 1)
    private String openId;
    /* 仓管员Id */
    @ExportConfig(value = "仓管员Id", width = 100, showLevel = 1)
    private String storageManage;
    /* 顺丰运单号 */
    @ExportConfig(value = "顺丰运单号", width = 100, showLevel = 1)
    private String waybillNo;
    /* 语言 */
    @ExportConfig(value = "语言", width = 100, showLevel = 1)
    private String language;
    /* 顺丰月结卡号 */
    @ExportConfig(value = "顺丰月结卡号", width = 100, showLevel = 1)
    private String monthlyCard;
    /* 快件产品类型 */
    @ExportConfig(value = "快件产品类型", width = 100, showLevel = 1)
    private String expressTypeId;
    /* 温度范围控制 1:冷藏 3：冷冻 */
    @ExportConfig(value = "温度范围控制 1:冷藏 3：冷冻", width = 100, showLevel = 1)
    private String temperatureRange;
    /* 联系人 */
    @ExportConfig(value = "联系人", width = 100, showLevel = 1)
    private String contact;
    /* 联系电话 */
    @ExportConfig(value = "联系电话", width = 100, showLevel = 1)
    private String mobile;
    /* 省份 */
    @ExportConfig(value = "省份", width = 100, showLevel = 1)
    private String province;
    /* 城市 */
    @ExportConfig(value = "城市", width = 100, showLevel = 1)
    private String city;
    /* 县/区级行政区名称 */
    @ExportConfig(value = "县/区级行政区名称", width = 100, showLevel = 1)
    private String county;
    /* 地址Id */
    @ExportConfig(value = "地址Id", width = 100, showLevel = 1)
    private String addressId;
    /* 详细地址 */
    @ExportConfig(value = "详细地址", width = 100, showLevel = 1)
    private String address;
    /* 发件时间 */
    @ExportConfig(value = "发件时间", width = 100, showLevel = 1)
    private Date sendExpressDate;
    /* 收件时间 */
    @ExportConfig(value = "收件时间", width = 100, showLevel = 1)
    private Date acceptExpressDate;
    /* 运单描述 */
    @ExportConfig(value = "运单描述", width = 100, showLevel = 1)
    private String waybillRemark;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /**
     * 非数据库字段
     */
    private String orderCode;//订单编码
    private String drugsNum;//商品数量
    private String drugsName;//商品名称
    private String drugsCode;//商品编码
    private String price;//价格
    private String memberName;//会员名称
    private String consultSheetCode;//咨询单编码
    private String storageManageName;//仓管员名称
    private String sendExpressDateStr;
    private String acceptExpressDateStr;
    private String createTimeStr;
    private String updateTimeStr;

    public Waybill() {
        this.delFlag = false;
        this.status = "0";
        this.expressTypeId = "12";
        this.temperatureRange = "0";
    }

}