package com.cftech.sys.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * log 实体类
 * 日志表
 * Created by lisw 02/09/2016.
 */ 
@Data
@NoArgsConstructor
public class Log implements Serializable {
	/**
	 * 编号
	 */
	private Long id;

	/**
	 * 日志类型
	 */
	private String type;

	/**
	 * 创建者
	 */
	private String createBy;

	/**
	 * 创建时间
	 */
	private Timestamp createDate; 

	/**
	 * 操作IP地址
	 */
	private String remoteAddr;

	/**
	 * 用户代理
	 */
	private String userAgent;

	/**
	 * 请求URI
	 */
	private String requestUri;

	/**
	 * 操作方式
	 */
	private String method;

	/**
	 * 操作提交的数据
	 */
	private String params;

	/**
	 * 异常信息
	 */
	private String exception;
	
	/**
	 * 公众号ID
	 */
	private Long appid;


	
	public static final String TYPE_ACCESS = "1";
	public static final String TYPE_EXCEPTION = "2";

}