package com.cftech.sys.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * log 实体类
 * 导出日志表
 * @author KangLiang Huang
 */ 
@Data
@NoArgsConstructor
public class ExportLog implements Serializable {
	/**
	 * 编号
	 */
	private Long id;

	/**
	 * 日志类型
	 */
	private String type;

	/**
	 * 创建者
	 */
	private String createBy;

	/**
	 * 创建时间
	 */
	private Timestamp createDate; 

	/**
	 * 操作IP地址
	 */
	private String remoteAddr;

	/**
	 * 用户代理
	 */
	private String userAgent;

	/**
	 * 请求URI
	 */
	private String requestUri;

	/**
	 * 操作方式
	 */
	private String method;

	/**
	 * 输出的SQL
	 */
	private String outsql;

	/**
	 * mybatis预编译的SQL
	 */
	private String orisql;

	/**
	 * 预编译的参数
	 */
	private String compileparams;

	/**
	 * 请求的参数
	 */
	private String params;

	/**
	 * 公众号ID
	 */
	private Long appid;

	
	public static final String TYPE_ACCESS = "1";
	public static final String TYPE_EXCEPTION = "2";

}