package com.cftech.sys.dao;

import com.cftech.core.mongo.Pager;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.model.MobileLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * mobileLogMapper
 * Created by mb 02/12/2016.
 */
@Repository
public class MobileLogMapper{
	
	@Autowired
    private MongoTemplate mongoTemplate;

	/**
     * 分页查询数据
     * @param userBo
     * @param pager
     * @return
     */
    public Pager selectPage(MobileLog mobileLog, Pager pager){
    	Query query = new Query();
    	Criteria criteria = new Criteria();
    	criteria.where("1").is("1");
    	if(mobileLog!=null){
    		if(StringUtils.isNotBlank(mobileLog.getField1())){//日志类型  1:访问日志  2:操作日志
    			criteria.and("field1").is(mobileLog.getField1());
        	}
    		if(StringUtils.isNotBlank(mobileLog.getField2())){//省市查询
    			criteria.and("field2").regex(mobileLog.getField2());
    		}
    		if(StringUtils.isNotBlank(mobileLog.getField3())){//省市查询
    			criteria.and("field3").regex(mobileLog.getField3());
    		}
    		if(StringUtils.isNotBlank(mobileLog.getField4())){//昵称
    			criteria.and("field4").regex(mobileLog.getField4());
    		}
    		if(StringUtils.isNotBlank(mobileLog.getOpenid())){//openId
    			criteria.and("openid").regex(mobileLog.getOpenid());
    		}
    		if(StringUtils.isNotBlank(mobileLog.getAppid())){
    			criteria.and("appid").regex(mobileLog.getAppid());
    		}
    		if(StringUtils.isNotBlank(mobileLog.getModule())){
    			criteria.and("module").regex(mobileLog.getModule());
    		}
    		if(StringUtils.isNotBlank(mobileLog.getModulename())){
    			criteria.and("modulename").regex(mobileLog.getModulename());
    		}
    	}
    	query.addCriteria(criteria);
    	if(pager.getPageSize()>0){
    		 query.skip(pager.getPageNum()*pager.getPageSize());
    	     query.limit(pager.getPageSize());
    	}
        Direction direction=false?Direction.ASC:Direction.DESC;
        query.with(new Sort(direction,"vt"));
        /*Criteria criteria = new Criteria();
        query.addCriteria(criteria);*/
        long total = mongoTemplate.count(query, MobileLog.class);
        List<MobileLog> users = mongoTemplate.find(query, MobileLog.class);
        pager.setResult(users);
        pager.setTotal(total);
        return pager;
    }
}
