package com.cftech.base.org.service;

import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.model.vo.QyOrgUserVO;
import com.cftech.base.org.model.vo.QyuserVO;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;
import java.util.Map;

/**
 * qyuserService
 * Created by Neil 14/02/2017.
 */
public interface QyuserService extends GenericService<Qyuser> {

    /**
     * 分页查询
     *
     * @param orgId   哪个组织下的人员列表
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<QyuserVO> fetchSearchVOByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize);

    List<Qyuser> fetchSearchByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize);

    int count(Long orgId, Conds conds);

    /**
     * 按条件改变记录的状态
     *
     * @param status 改变成的状态
     * @param conds  条件
     */
    void changeStatus(String status, Conds conds);

    /**
     * 按条件改变tagids的值
     *
     * @param tagIds 具有的tagIds
     * @param conds  条件
     */
    void changeTagIds(String tagIds, Conds conds);

    /**
     * 更新人员门店信息
     * @param id 人员id
     * @param role  门店角色
     * @param storeId 门店Id
     * @param storeName 门店名称
     */
    void updateStoreInfo(Long id, String role, Long storeId, String storeName);
    /**
     * 查询所有下属人员信息(不包含自己)
     * @param userId
     * @return
     */
    List<QyuserVO> getSubordinateUser(Long positionId, Long orgId, Long userId, Long accountsId, int page, int pageSize, Sort sort, String name);
    
    /**
     * 查询所有下属组织及下级人员
     * @param params
     * @return
     */
    List<QyOrgUserVO> getOrgSubordinateUser(Map<String, Object> params);

    /**
     * 按条件追加tagid
     *
     * @param tagIds 具有的tagIds
     * @param conds  条件
     */
    void appendTagids(String tagIds, Conds conds);
    
    /**
     * 根据所选部门查询出部门下面的所有下级人员
     * @param params
     * @return
     */
    List<Qyuser> getOrgUserList(Map<String, Object> params);

    /**
     * 根据标签查询标签的人员列表，标签是正则表达式
     *
     * @param accountsId
     * @param delFlag
     * @param regTagIds
     * @return
     */
    List<Qyuser> findUsersByTagIds(Long accountsId, String delFlag, String regTagIds);


    List<Qyuser> getLogInfo(Map<String, Object> params);
}
