var photo = (function () {
  'use strict';
  var Photo = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/album/getalbumdetails',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/photo.json';
    }
 p.english = cfApp.getQueryString('english') == 1 ? true : false;
    p.previewImg = [];
    console.log(p.english);

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {
        var sideDiv = new side({
          currentIndex: '5',
          cfApp:cfApp

        });
        sideDiv.init();
        log();
        loadData();
       
  $('.language').click(function () {
    if(!p.english){
 location.href = 'photo-english.html?appid=' + p.params.appid + '&albumId=' + cfApp.getQueryString('albumId')+'&time='+'&english=1'+'&id='+cfApp.getQueryString('id');
    }else{
 location.href = 'photo.html?appid=' + p.params.appid + '&albumId=' + cfApp.getQueryString('albumId')+'&time='+cfApp.getQueryString('time')+'&id='+cfApp.getQueryString('id');
    }
        });
        return true;
      } else {
        return false;
      }
    };
    var log = function () {

      var formdata = {
        openid: p.empInfo.openId,
        module: "研讨会",
        modulename: "相册详情",
        keyword: "相册详情",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {
      $.showLoading();
      var formdata = {
        createtime: cfApp.getQueryString('time'),
        id: cfApp.getQueryString('albumId')
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        if (retdata.errorNo == '0') {
          console.log(retdata.data);
          $('title').html(cfApp.getQueryString('time'));
          var content = $('#template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata);
          $('.content').append(htmlStr);
          swiperInit();
           var preview = $(".swiper1 .swiper-slide img");
           for(var i=0;i<preview.length;i++){
               p.previewImg.push($(preview[i]).attr("src"));
           }
            $("body").on("click",".swiper1 img",function(){
                var obj=$(this);
                wx.previewImage({
                    current:obj.attr("src") , // 当前显示图片的http链接
                    urls: p.previewImg // 需要预览的图片http链接列表
                });
            })
        }
      });


    }

    var swiperInit = function () {
      var mySwiper1 = new Swiper('.swiper1', {
        effect: 'coverflow',
        slidesPerView: 1.38,
        centeredSlides: true,
        coverflowEffect: {
          rotate: -30,
          stretch: -30,
          depth: 300,
          modifier: 1,
          slideShadows: true
        },
        navigation: {
          nextEl: '.swiper-button-next',
          prevEl: '.swiper-button-prev',
        },
        on: {
          slideChange: function () {
            if (this.isEnd) {
              this.navigation.$nextEl.css('display', 'none');
            } else {
              this.navigation.$nextEl.css('display', 'block');
            }
          },
        },
      });
      var mySwiper2 = new Swiper('.swiper2', {
       
        slidesPerView: 4.22,
        spaceBetween: 10,
        slidesOffsetBefore: 10,
        slidesOffsetAfter: 10,
        on:{
            tap: function(event){
             
                mySwiper1.slideTo(this.clickedIndex);
            },
          }
      })
    }


  };

  return Photo;
})();