package com.cftech.addresst.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aspose.words.IFieldMergingCallback;
import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.addresst.model.Address;
import com.cftech.addresst.dao.AddressMapper;
import com.cftech.addresst.model.AddressVO;
import com.cftech.addresst.model.Area;
import com.cftech.addresst.service.AddressService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.sys.security.UserUtils;
import com.esotericsoftware.minlog.Log;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.record.chart.AxisUsedRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

/**
* 收货地址管理ServiceImpl
*
* @author Licc
* @date: 2020-09-29 17:17
*/
@Service("addressService")
public class AddressServiceImpl extends GenericServiceImpl<Address> implements AddressService {

    @Autowired
    @Qualifier("addressMapper")
    private AddressMapper addressMapper;
    @Autowired
    private MpAccountsService mpAccountsService;
    @Override
    public GenericDao<Address> getGenericMapper() {
        return addressMapper;
    }

    @Override
    public List<Area> listArea() {
        return addressMapper.listArea();
    }

    @Override
    public JSONObject addressList(String openId,String appId) {
        JSONObject rtnJson = new JSONObject();
        try {

            if (StringUtils.isBlank(openId)) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "openId不能为空");
                return rtnJson;
            }
             MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<AddressVO> addressList = addressMapper.addressList(openId);
            Log.info("参数:" + addressList);
            if (!addressList.equals("") || addressList != null) {
                rtnJson.put("errorNo", "0");
                rtnJson.put("data", addressList);
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
        }

        return rtnJson;
    }

    @Override
    public JSONObject addressId(Long id,String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (id.equals("")) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "id不能为空");
                return rtnJson;
            }
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<AddressVO> addressVOS = addressMapper.addressId(id);
            if (addressVOS!=null){
                Log.info("参数:"+addressVOS);
                rtnJson.put("errorNo","0");
                rtnJson.put("errorMsg",addressVOS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNO", "1");
        }
        return rtnJson;
    }


    @Transactional
    @Override
    public JSONObject addressAdd(Address address) {
        JSONObject rtnJson = new JSONObject();

        Address newAddress = new Address();
        try {
            if (StringUtils.isEmpty(address.getOpenId())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "openid不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(address.getAddressName())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "收货人姓名不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(address.getPhone())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "手机号码不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(address.getAddress())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "详细地址不能为空");
                return rtnJson;
            }
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(address.getAppId());
            newAddress.setOpenId(address.getOpenId());
            newAddress.setAccountsId(address.getAccountsId());
            newAddress.setAddressName(address.getAddressName());
            newAddress.setPhone(address.getPhone());
            newAddress.setAddress(address.getAddress());
            newAddress.setProvinceId(address.getProvinceId());
            newAddress.setCityId(address.getCityId());
            newAddress.setAreaId(address.getAreaId());

            if ("1".equals(address.getWhether().toString())) {
                HashMap<String, Object> param = new HashMap<>();
                param.put("whether", address.getWhether());
                param.put("openId", address.getOpenId());
                //更新粉丝所有默认
                addressMapper.updateWhether(param);
                //增加默认
                addressMapper.save(address);
                rtnJson.put("errorNo", "0");
            } else {
                addressMapper.save(address);
                rtnJson.put("errorNo", "0");
                rtnJson.put("errorMsg", "新增成功");
            }
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo","1");
        }
        return rtnJson;
    }

    @Transactional
    @Override
    public JSONObject updateAddress(Address address) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (StringUtils.isEmpty(address.getOpenId())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "openid不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(address.getAddressName())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "收货人姓名不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(address.getPhone())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "手机号码不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(address.getAddress())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "详细地址不能为空");
                return rtnJson;
            }
            Log.info("参数:" + address);
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(address.getAppId());
            address.setId(address.getId());
            address.setAddressName(address.getAddressName());
            address.setPhone(address.getPhone());
            address.setAddress(address.getAddress());
            address.setProvinceId(address.getProvinceId());
            address.setCityId(address.getCityId());
            address.setAreaId(address.getAreaId());
            if ("1".equals(address.getWhether().toString())) {
                address.setWhether(address.getWhether());
                Long whether = address.getWhether();
                String openId = address.getOpenId();
                Integer list = addressMapper.whetherList(openId);
                if (list != null) {
                    HashMap<String, Object> param = new HashMap<>();
                    param.put("whether", whether);
                    param.put("openId", openId);
                    int i = addressMapper.updateWhether(param);
                    if (!(i > 0)) {
                        rtnJson.put("errorNo", "1");
                        rtnJson.put("errorMsg", "修改失败");
                        return rtnJson;
                    }
                }
            }
            int i = addressMapper.update(address);
            if (i > 0) {
                rtnJson.put("errorNo", "0");
                rtnJson.put("errorMsg", "修改成功");
            } else {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "修改失败");
            }
        } catch (Exception e) {
            e.printStackTrace();

        }
        return rtnJson;
    }

    @Override
    public JSONObject deleteAddress(String id,String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (StringUtils.isBlank(id)) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "id不能为空");
                return rtnJson;
            }
            int delete = addressMapper.delete(id);
            if (delete > 0) {
                rtnJson.put("errorNo", "0");
                rtnJson.put("errorMsg", "删除成功");
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", "0");
        }
        return rtnJson;
    }

}