package com.cftech.order.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.order.model.OrderMobileDto;
import com.cftech.order.service.OrderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @author ：licc
 * @date ：Created in 2020/10/30 15:40
 * @description：
 */
@Slf4j
@RestController
@CrossOrigin
@RequestMapping("mobile/auth/order")
public class MobileOrderController {
    @Autowired
    private OrderService orderService;

    /**
     * @return
     * @Author Licc
     * @Description 订单信息
     * @Date 15:43 2020/10/30
     * @Param
     **/
    @RequestMapping(value = "/confirm", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject confirm(OrderMobileDto orderMobileDto) {
        return orderService.confirm(orderMobileDto);
    }

    /**
     * @return
     * @Author Licc
     * @Description 个人中心订单统计
     * @Date 19:03 2020/11/3
     * @Param
     **/
    @RequestMapping(value = "/orderSize", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject orderSize(String openId,String appId) {
        return orderService.orderSize(openId, appId);
    }

    /**
     * @return
     * @Author Licc
     * @Description 根据搜索条件查询订单
     * @Date 19:40 2020/11/3
     * @Param
     **/
    @RequestMapping(value = "/orderList", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject orderList(OrderMobileDto orderMobileDto) {
        return orderService.orderList(orderMobileDto);
    }
}
