package com.cftech.activity.oil.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 机油活动配置
 *
 * @author faye
 * @date: 2017-08-23 13:50
 */
@Data
public class Config implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 名称 */
    @ExportConfig(value = "名称", width = 100)
    private String name;
    /* 动作类型 */
    @ExportConfig(value = "动作类型", width = 100)
    private String type;
    /* 机油数 */
    @ExportConfig(value = "机油数", width = 100)
    private String count;
    /* 单位 */
    @ExportConfig(value = "单位", width = 100)
    private String unit;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Config() {
        this.delFlag = false;
        this.status = "0";
    }

}