package com.cftech.workshop.sample.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.meeting.service.MeetingService;
import com.cftech.workshop.sample.model.Sample;
import com.cftech.workshop.sample.service.SampleService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.htmlparser.tags.Html;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String SAMPLE_VIEW = "qy:sample:view"
 * 查看:public static final String SAMPLE_EDIT = "qy:sample:edit"
 *
 * @author byj
 * @date: 2018-06-29 13:43
 */
@Slf4j
@Controller
@RequestMapping("/a/sample")
public class SampleController {

    public static final String SAMPLE_VIEW = "qy:sample:view";
    public static final String SAMPLE_EDIT = "qy:sample:edit";

    @Autowired
    private SampleService sampleService;
    @Autowired
    private CodingruleUtils codingruleUtils;

    @Autowired
    private MeetingService meetingService;


    //列表页面
    @RequiresPermissions(value = SAMPLE_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,Long meetingId) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId",meetingId);
        return "sample/samplelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = SAMPLE_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model, Long meetingId ) {
        if (!StringUtils.isEmpty(id)) {
            Sample sample = sampleService.fetchById(id);
            sample.setContent_sample(ESAPI.encoder().decodeForHTML(sample.getContent_sample()));
            sample.setContent_sample_en(ESAPI.encoder().decodeForHTML(sample.getContent_sample_en()));
            model.addAttribute("data", sample);
        }
        model.addAttribute("meetingId",meetingId);
        return "sample/sampleform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = SAMPLE_EDIT)
    @RequestMapping( value = "/formData" ,method = RequestMethod.POST)
    @ResponseBody
    public JSONObject formData(Sample sample, Model model, HttpServletRequest request ) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (sample != null && sample.getId() != null) {
                sample.setUpdateBy(UserUtils.getUser().getId());
                sampleService.update(sample);
                rtnJson.put("errorNo", 0);
            } else {
                sample.setNumber(codingruleUtils.getNumber(accountsId, Sample.class.getName()));
                sample.setAccountsId(accountsId);
                sample.setDelFlag(false);
                sample.setAccountsId(UserUtils.getmpaccounts(request));
                sample.setCreateBy(UserUtils.getUser().getId());
                sample.setUpdateBy(UserUtils.getUser().getId());
                sample.setClicks(Long.valueOf(0));
                sampleService.save(sample);
                meetingService.synMobileMenu();
                rtnJson.put("errorNo", 2);
            }

        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = SAMPLE_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Sample sample, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);

        if (!StringUtils.isEmpty(sample.getSample_title())) {
            conds.like("sample_title", sample.getSample_title());
        }

        if (!StringUtils.isEmpty(sample.getWorkshop_id())) {
            conds.equal("workshop_id", sample.getWorkshop_id());
        }
        if (!StringUtils.isEmpty(sample.getContent_sample())) {
            conds.equal("content_sample", sample.getContent_sample());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Sample> list = sampleService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = sampleService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = SAMPLE_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            sampleService.delete(id);
            meetingService.synMobileMenu();
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
