package com.cftech.showroom.appform.model;

import com.cftech.core.poi.ExportConfig;
import com.cftech.core.util.DateUtils;
import com.cftech.core.util.StringUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 展厅申请单
 *
 * @author lisw
 * @date: 2019-07-31 15:40
 */
@Data
public class AppForm implements Serializable {

    /* 主键id */
    private Long id;

    @ExportConfig(value = "序号", width = 100)
    private String no;
    /* 编码 */
    @ExportConfig(value = "Application no \r\n 申请单号 ", width = 100)
    private String number;

    /* 创建时间 */
    @ExportConfig(value = "Application Time \r\n 申请提交时间", width = 100,dateFormat = "yyyy/MM/dd HH:mm")
    private Date createTime;

    /* 申请人 */
    @ExportConfig(value = "Applicant \r\n 申请者", width = 100)
    private String name;
    /* 申请人部门 */
    //@ExportConfig(value = "申请人邮箱", width = 100)
    private String email;

    private Long department;

    //部门名称
    @ExportConfig(value = "Applicant Div./ Dep. \r\n 申请部门", width = 100)
    private String dname;

    @ExportConfig(value = "Booking Date \r\n 来访日期", width = 100)
    private String date;

    @ExportConfig(value = "Booking Time \r\n 来访时间", width = 100)
    private String timeStr;


    /* 申请日期 */
    //@ExportConfig(value = "预约日期", width = 100,dateFormat = "yyyy-MM-dd")
    private Date reservationDate;
    /* 申请时间段开始时间 */
    //@ExportConfig(value = "预约时间段开始时间", width = 100,dateFormat = "yyyy-MM-dd HH:mm")
    private Date reservationBeginTime;
    /* 申请时间段结束时间 */
    //@ExportConfig(value = "预约时间段结束时间", width = 100,dateFormat = "yyyy-MM-dd  HH:mm")
    private Date reservationEndTime;
    /* 来访者类别 */
    private Long visitorCategory;


    /* 申请事由 */
    @ExportConfig(value = "Booking Reason  \r\n 来访事由", width = 100)
    private String applyContent;


    @ExportConfig(value = "Visitor Type \r\n 来访者类别 ", width = 100)
    private String vname;
    /* 来访者人数 */
    @ExportConfig(value = "Visitor No. \r\n 来访者人数", width = 100)
    private Integer visitorNum;

    /* 讲解人 */
    private Long explainer;

    //讲解人姓名
    @ExportConfig(value = "Brand Ambassador Needed \r\n 是否需要品牌大使", width = 100)
    private String isExplainer;

    /**
     * 无讲解人原因
     * 0:约到讲解人
     * 1:不需要
     * 2:时间冲突无法预约
     */
    private String explainerStatus;




    //讲解人姓名

    @ExportConfig(value = "Brand Ambassador \r\n 品牌大使", width = 100)
    private String ename;


    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;

    private Date cancelTime;
    /* 更新时间 */

    private Date updateTime;
    /* 备注 */

    @ExportConfig(value = "Other Remarks \r\n 其他需求", width = 100)
    private String description;
    /* 状态 */

    private String status;

    @ExportConfig(value = "Status \r\n 状态", width = 100)
    private String statusName;

    @ExportConfig(value = "OPENID", width = 100)
    private String openid;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    //后台管理员备注
    @ExportConfig(value = "管理员备注", width = 100)
    private String remarks;




    private  String fileurl;
    private String beginDateTimeStr;
    private String endDateTimeStr;
    private String ccmail;
    private String tomail;







    public void setReservationBeginTime(Date reservationBeginTime) {
        this.reservationBeginTime = reservationBeginTime;
        this.date = DateUtils.formatDate(reservationBeginTime,"yyyy/MM/dd");
    }


    public void setReservationEndTime(Date reservationEndTime) {
        this.reservationEndTime = reservationEndTime;
        this.timeStr = DateUtils.formatDate(reservationBeginTime,"HH:mm")+"-"+DateUtils.formatDate(this.reservationEndTime,"HH:mm");
    }


    public void setExplainer(Long explainer) {
        this.explainer = explainer;
        if(explainer!=null){
            this.isExplainer="Yes";
        }else{
            this.isExplainer="No";
        }
    }

    public void setStatus(String status) {
        this.status = status;
        if(status.equals("0")){
            this.statusName="已预约";
        }
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
        if(cancelTime!=null){
            this.statusName=DateUtils.formatDate(this.cancelTime,"yyyy-MM-dd HH:mm")+"已取消";
        }
    }

    public AppForm() {
        this.delFlag = false;
        this.status = "0";
        this.isExplainer="No";
    }

}