package com.cftech.common.grantitems.service.impl;

import com.cftech.common.grantitems.model.Grantitems;
import com.cftech.common.grantitems.dao.GrantitemsMapper;
import com.cftech.common.grantitems.service.GrantitemsService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 申请单详情ServiceImpl
*
* @author faye
* @date: 2019-08-19 09:45
*/
@Service("grantitemsService")
public class GrantitemsServiceImpl extends GenericServiceImpl<Grantitems> implements GrantitemsService {

@Autowired
@Qualifier("grantitemsMapper")
private GrantitemsMapper grantitemsMapper;

@Override
public GenericDao<Grantitems> getGenericMapper() {
return grantitemsMapper;
}

    @Override
    public List<Grantitems> fetchGrantItems(Conds conds) {
        Map<String,Object> params = new HashMap<>();
        params.put("conds",conds);
        return grantitemsMapper.fetchGrantItems(params);
    }
}