package com.cftech.mchaccounts.mch.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.mchaccounts.mch.model.MchAccounts;
import com.cftech.mchaccounts.mch.service.MchAccountsService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 商戶信息Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String MCHACCOUNTS_VIEW = "qy:mchAccounts:view"
 * 查看:public static final String MCHACCOUNTS_EDIT = "qy:mchAccounts:edit"
 *
 * @author Kangliang
 * @date: 2017-05-16 16:43
 */
@Slf4j
@Controller
@RequestMapping("/a/mchAccounts")
public class MchAccountsController {

    public static final String MCHACCOUNTS_VIEW = "qy:mchAccounts:view";
    public static final String MCHACCOUNTS_EDIT = "qy:mchAccounts:edit";

    @Autowired
    private MchAccountsService mchAccountsService;


    //列表页面
    @RequiresPermissions(value = MCHACCOUNTS_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "mchAccounts/mchAccountslist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = MCHACCOUNTS_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            MchAccounts mchAccounts = mchAccountsService.fetchById(id);
            model.addAttribute("data", mchAccounts);
        }
        return "mchAccounts/mchAccountsform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = MCHACCOUNTS_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(MchAccounts mchAccounts, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (mchAccounts != null && mchAccounts.getId() != null) {
                mchAccounts.setUpdateBy(UserUtils.getUser().getId());
                mchAccountsService.update(mchAccounts);
                rtnJson.put("errorNo", 0);
            } else {
                mchAccounts.setAccountsId(accountsId);
                mchAccounts.setDelFlag(false);
                mchAccounts.setAccountsId(UserUtils.getmpaccounts(request));
                mchAccounts.setCreateBy(UserUtils.getUser().getId());
                mchAccounts.setUpdateBy(UserUtils.getUser().getId());
                mchAccountsService.save(mchAccounts);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = MCHACCOUNTS_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, MchAccounts mchAccounts, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(mchAccounts.getMchaccounts())) {
            conds.equal("mchaccounts", mchAccounts.getMchaccounts());
        }
        if (!StringUtils.isEmpty(mchAccounts.getSrctype())) {
            conds.like("srctype", mchAccounts.getSrctype());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<MchAccounts> list = mchAccountsService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = mchAccountsService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = MCHACCOUNTS_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            mchAccountsService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = MCHACCOUNTS_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<MchAccounts> list = mchAccountsService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(MchAccounts.class, response).toExcel(list, "商戶信息信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = MCHACCOUNTS_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(MchAccounts.class, response).toExcel(null, "商戶信息信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = MCHACCOUNTS_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    MchAccounts mchAccounts = new MchAccounts();
                    mchAccounts.setAccountsId(accountId);
                    mchAccountsService.save(mchAccounts);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return list(request, model);
    }

}
