package com.cftech.mchaccounts.mch.service.impl;

import com.cftech.mchaccounts.mch.model.MchAccounts;
import com.cftech.mchaccounts.mch.dao.MchAccountsMapper;
import com.cftech.mchaccounts.mch.service.MchAccountsService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
* 商戶信息ServiceImpl
*
* @author Kangliang
* @date: 2017-05-16 16:43
*/
@Service("mchAccountsService")
public class MchAccountsServiceImpl extends GenericServiceImpl<MchAccounts> implements MchAccountsService {

@Autowired
@Qualifier("mchAccountsMapper")
private MchAccountsMapper mchAccountsMapper;

@Override
public GenericDao<MchAccounts> getGenericMapper() {
return mchAccountsMapper;
}


    @Override
    public List<MchAccounts> getAll(Map<String, Object> params) {
        return mchAccountsMapper.getAll(params);
    }
}