package com.cftech.mp.fans.model;

import com.cftech.sys.model.BasicEntity;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import java.util.Date;
/**
 * 服务号粉丝账户信息
 * @author lisw
 *
 */
@JsonSerialize
@Data
@JsonNaming(PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class)
public class MpFanssEntity extends BasicEntity{
	private static final long serialVersionUID = -2537256381609738771L;
	private String openid; //公众号OPENID
	private String nickname; //粉丝姓名 
	private String sex; //粉丝性别 
	private String city; //粉丝来源城市 
	private String province; //粉丝来源省会 
	private String country; //粉丝国家 
	private String headimgurl;//粉丝头像 
	private Date subscribetime; //关注事件 
	private String unionid;//UNIONID  
	private Long mpaccountid;// 来源服务号ID 
	private String taglist; //标签列表
	
	private String source;//来源  1.导购二维码 2.门店二维码 3.普通关注
	
	private String recommender;//推荐人 
	
	private Long store;//门店
	
	private String status;
	
	private String canceltime;  //粉丝取消关注时间
	
	/**
	 * 粉丝标签,中文名
	 * @return
	 */
	private String tags; 
	
	
	
	
	
	public String getTags() {
		return tags;
	}
	public void setTags(String tags) {
		this.tags = tags;
	}
	public String getCanceltime() {
		return canceltime;
	}
	public void setCanceltime(String canceltime) {
		this.canceltime = canceltime;
	}
	/**
	 * 
	 * @return
	 */
	private String storeName;
	
	
	
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public String getSource() {
		return source;
	}
	public void setSource(String source) {
		this.source = source;
	}
	public String getRecommender() {
		return recommender;
	}
	public void setRecommender(String recommender) {
		this.recommender = recommender;
	}

	public Long getStore() {
		return store;
	}

	public void setStore(Long store) {
		this.store = store;
	}

	public String getStoreName() {
		return storeName;
	}
	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}
	public String getTaglist() {
		return taglist;
	}
	public void setTaglist(String taglist) {
		this.taglist = taglist;
	}
	public Long getMpaccountid() {
		return mpaccountid;
	}
	public void setMpaccountid(Long mpaccountid) {
		this.mpaccountid = mpaccountid;
	}
	public Date getSubscribetime() {
		return subscribetime;
	}
	public void setSubscribetime(Date subscribetime) {
		this.subscribetime = subscribetime;
	}
	public String getOpenid() {
		return openid;
	}
	public void setOpenid(String openid) {
		this.openid = openid;
	}
	public String getNickname() {
		return nickname;
	}
	public void setNickname(String nickname) {
		this.nickname = nickname;
	}
	public String getSex() {
		return sex;
	}
	public void setSex(String sex) {
		this.sex = sex;
	}
	public String getCity() {
		return city;
	}
	public void setCity(String city) {
		this.city = city;
	}
	public String getProvince() {
		return province;
	}
	public void setProvince(String province) {
		this.province = province;
	}
	public String getCountry() {
		return country;
	}
	public void setCountry(String country) {
		this.country = country;
	}
	public String getHeadimgurl() {
		return headimgurl;
	}
	public void setHeadimgurl(String headimgurl) {
		this.headimgurl = headimgurl;
	}

	public String getUnionid() {
		return unionid;
	}
	public void setUnionid(String unionid) {
		this.unionid = unionid;
	}
	@Override
	public String toString() {
		return "MpFanssEntity [openid=" + openid + ", nickname=" + nickname
				+ ", sex=" + sex + ", city=" + city + ", province=" + province
				+ ", country=" + country + ", headimgurl=" + headimgurl
				+ ", subscribetime=" + subscribetime + ", unionid=" + unionid
				+ ", mpaccountid=" + mpaccountid  + "]";
	}
}
